<?php $__env->startSection('content'); ?>
<br/>

<?php
    $user = Auth::user()->id;
    $wealthCreations = DB::table('wealthcreation')->where('user_id', $user)->get();
?>

<div class="container">
    <center>
         <div class="card-header fs-bold">Wealth Fund History</div>
    </center>
   
    <div class="table-responsive p-2 rounded">
        <table class="table table-bordered table-hover table-sm custom-table">
            <thead class="thead-custom">
                <tr>
                    <th scope="col">Capital</th>
                    <th scope="col">Daily Income</th>
                    <th scope="col">Days Paid</th>
                    <th scope="col">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $wealthCreations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wealth): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="table-row">
                        <td class="capital-column"><?php echo e(number_format($wealth->capital  * $settings->rate, 2)); ?></td>
                        <td class="income-column"><?php echo e(number_format($wealth->returns  * $settings->rate, 2)); ?></td>
                        <td class="days-paid-column"><?php echo e($wealth->days_paid); ?>/40</td>
                        <td class="status-column text-center">
                            <?php if($wealth->status == 1): ?>
                                <span class="badge badge-success"><i class="fas fa-check-circle"></i> Active</span>
                            <?php else: ?>
                                <span class="badge badge-danger"><i class="fas fa-times-circle"></i> Inactive</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .custom-table {
        background-color: #f9f9f9;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }
    .thead-custom {
        background-color: #4CAF50;
        color: #fff;
        font-weight: bold;
    }
    .thead-custom th {
        border: none;
    }
    .table-row:nth-child(even) {
        background-color: #f1f1f1;
    }
    .table-row:hover {
        background-color: #e3f2fd;
    }
    .capital-column,
    .income-column,
    .days-paid-column {
        font-weight: bold;
    }
    .capital-column {
        color: #333;
    }
    .income-column {
        color: #4CAF50;
    }
    .status-column span {
        font-size: 14px;
        font-weight: 600;
    }
    .badge-success {
        background-color: #4CAF50;
    }
    .badge-danger {
        background-color: #f44336;
    }
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/cdp24.site/resources/views/user/wealthhistory.blade.php ENDPATH**/ ?>