<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="generator" content="">
    <title><?php echo e(env('APP_NAME')); ?></title>


    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">

    <!-- Style CSS for this template -->
    <link href="public/assets/css/style.css" rel="stylesheet" id="style">
    <!--<link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-alpha/css/bootstrap.css" rel="stylesheet">-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <style>
        .product-item {
            @apply flex mb-20 border-rounded-8;
        }

        .product-image {
            @apply w-125 h-150 border-rounded-8 overflow-hidden;
        }

        .product-image img {
            @apply w-full h-full object-cover;
        }

        .tags {
            @apply text-red-500 ml-10;
        }

        .product-details {
            @apply flex-1 px-10;
        }

        .product-name {
            @apply flex items-center;
        }

        .cycles-label {
            @apply ml-auto text-green-500;
        }

        .product-price {
            @apply text-green-500 bg-indigo-900 underline;
        }

        .return-rate {
            @apply text-blue-500;
        }

        .countdown-timer {
            @apply ml-auto;
        }

        .income-section {
            @apply flex justify-between mt-10;
        }

        .day-income,
        .total-income {
            @apply text-green-500 bg-gray-900;
        }
    </style>
    <link href="assets/css/global.css" rel="stylesheet" >
    <!--tailwind css 3-->
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@latest/dist/tailwind.min.css" rel="stylesheet">
</head>

<body class="body-scroll" data-page="addmoney" style="">

    <!-- Loader section -->

    <!-- Loader section ends -->
    <?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Begin page -->
    <main class="h-screen mt-2 pt-2">

        <!-- Header -->
        <header class="fixed top-0 left-0 right-0 text-white  p-4 z-10">
            <div class="flex items-center justify-between">
                <div class="">
                    <a href="home">
                        <button type="button" class="bg-gray-100 shadow rounded-lg text-gray-700 px-2 font-bold">
                            <i class="bi bi-arrow-left"></i>
                        </button>
                    </a>
                </div>
              
            </div>
        </header>
        <!-- Header ends -->
        <!-- Main page content -->
        <div class="container mt-20">
            <!-- Select Amount -->
            <?php
               $packages = DB::table('packages')->get();
            ?>
            <center>
            <?php if($errors->any()): ?>
                 <h4 style="color:red;"><?php echo e($errors->first()); ?></h4>
            <?php endif; ?>
            <?php if(\Session::has('success')): ?>
            
                <div class="alert text-green-500">
                    <ul>
                        <li><?php echo \Session::get('success'); ?></li>
                    </ul>
                </div>
            <?php endif; ?>
            
           <?php if(\Session::has('error')): ?>
                <div class="alert text-rose-600">
                    <ul>
                        <li><?php echo \Session::get('error'); ?></li>
                    </ul>
                </div>
            <?php endif; ?>
            </center>
            
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div style="border:2px rgb(224, 220, 220) solid;" class="mb-1 m-2">
                    
                    <a href="package?p=<?php echo e($pkg->id); ?>"  class="image-full mt-3 rounded-lg">
                        <figure class='relative rounded'>
                            <img src="<?php echo e(env('APP_RES')); ?>/bgs/p1.png" alt="bg" class="w-48 object-cover rounded"> 
            
                        </figure>

                        <div class="card-body">
                            <div class="block space-y-2 text-center">
                                <p class="uppercase font-semibold">Capital: KES.<?php echo e(number_format($pkg->price)); ?></p>
                                <p class="font-medium uppercase">Daily Income: KES.<?php echo e(number_format($pkg->daily_income)); ?></p>
                            </div>
                            <div class="block mb-2 text-center">
                                <p>Upline Bonus: <?php echo e($pkg->upline_bonus); ?></p>
                                <p>Days: <?php echo e($pkg->days); ?></p>
                            </div>
                        </div>
                        <button class="m-2 bg-blue-500 w-80 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">Open Account</button>
                    </a>

                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- Coupon code -->
            <?php
                $datas = DB::table('invest')->where('type', 0)->where('user_id', Auth::user()->id)->get();
            ?>

            <div class="row m-2">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="text-center">
                                    <p class="font-bold mb-0">Capital:</p>
                                </div>
                            </th>
                            <th>
                                <div class="text-center">
                                    <p class="font-bold mb-0">Daily:</p>
                                </div>
                            </th>
                            <th>
                                <div class="text-center">
                                    <p class="font-bold mb-0">Date Invested:</p>
                                </div>
                            </th>
                            <th>
                                <div class="text-center">
                                    <p class="font-bold mb-0">Days Earned:</p>
                                </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <div class="text-center">
                                    <p class="text-xs font-bold mb-0">
                                        <h6 class="text-sm mb-0"><?php echo e($data->capital); ?></h6>
                                    </p>
                                </div>
                            </td>
                            <td>
                                <div class="text-center">
                                    <p class="font-bold mb-0">
                                        <h6 class="text-sm mb-0"><?php echo e($data->returns); ?> </h6>
                                    </p>
                                </div>
                            </td>
                            <td class="align-middle text-sm">
                                <div class="col text-center">
                                    <p class="text-xs font-bold mb-0">
                                        <?php
                                            $eat = $data->date;
                                            $date = "2021-11-01 10:10:05";
                                            $newDate = date('Y-m-d H:i:s', strtotime($eat. ' + 0 hours'));
                                        ?>
                                        <h6 class="text-sm mb-0"><?php echo e($newDate); ?></h6>
                                    </p>
                                </div>
                            </td>
                            <td class="align-middle text-sm">
                                <div class="col text-center">
                                    <p class="font-bold mb-0">
                                        <h6 class="text-sm mb-0">
                                            <?php if($data->status == 1): ?>
                                                <?php echo e($data->days_paid); ?>

                                            <?php endif; ?>

                                            <?php if($data->status == 2): ?>
                                                Expired!!
                                            <?php endif; ?>
                                        </h6>
                                    </p>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <script>
                $(document).ready(function () {
                    $('#amount_to_invest').on('input', function () {
                        var inputValue = $(this).val();
                        $('#outputDiv').text('kes:' + ((inputValue * 0.08).toFixed(2)));
                    });
                });
            </script>

        </div>
        <!-- Main page content ends -->

    </main>
    <!-- Page ends -->


</body>

</html>
<?php /**PATH /home/uniquesq/etica.digital-pay.top/resources/views/investment.blade.php ENDPATH**/ ?>