<?php $__env->startSection('content'); ?>

<!-- Begin Request Funds Form -->
<div class="menu-size mb-5">
       <!-- Display Validation Errors -->
    <?php if($errors->any()): ?>
        <div class="alert alert-danger text-sm text-center" role="alert">
            <ul class="list-none p-0 m-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    
    <?php if(\Session::has('error')): ?>
        <div class="alert alert-danger">
            <ul>
                <li><?php echo \Session::get('error'); ?></li>
            </ul>
        </div>
    <?php endif; ?>
    
    <?php if(\Session::has('success')): ?>
        <div class="alert alert-success">
            <ul>
                <li><?php echo \Session::get('success'); ?></li>
            </ul>
        </div>
    <?php endif; ?>
    

    <!-- Form to request funds -->
    <form method="POST" id="withdrawalForm" class="w-full p-4" action="<?php echo e(route('withdraw')); ?>" onsubmit="disableButton()">
    <?php echo csrf_field(); ?>
    <input id="uniquekey" type="hidden" name="uniquekey">
    <center><b>Withdraw From Account</b></center>

    <div class="content mt-3">
        <!-- Phone Input -->
        <div class="form-custom form-label form-icon mb-4">
            <i class="bi bi-person-circle text-lg"></i>
            <label for="phone" class="form-label-always-active color-highlight text-sm">Enter Phone Number</label>
            <span class="text-xs">(required)</span>
            <input 
                type="tel" 
                readonly
                name="phone" 
                class="form-control rounded-xs mt-2 w-full p-3 text-base" 
                id="phone" 
                value="<?php echo e(Auth::user()->phone); ?>" 
                placeholder="<?php echo e(Auth::user()->phone); ?>" 
                required 
            />
        </div>

        <!-- Amount Input -->
        <div class="form-custom form-label form-icon mb-4">
            <i class="bi bi-cash text-lg"></i>
            <label for="amount" class="form-label-always-active color-highlight text-sm">Amount</label>
            <span class="text-xs">(Currency: <?php echo e($settings->currency); ?>)</span>
            <input 
                type="number" 
                name="amount" 
                class="form-control rounded-xs mt-2 w-full p-3 text-base" 
                id="amount" 
                placeholder="Amount" 
                required 
                min="<?php echo e(55 * $settings->rate); ?>" 
                step="0.01"
            />
        </div>

        <!-- Fee and Final Amount Display -->
        <div class="mt-4">
            <p class="text-sm font-semibold">Transaction Fee & Taxes (10%): <span id="transactionFee">0.00</span> <?php echo e($settings->currency); ?></p>
            <p class="text-sm font-semibold">Amount You Will Receive: <span id="finalAmount">0.00</span> <?php echo e($settings->currency); ?></p>
        </div>

        <!-- Submit Button -->
        <button 
            type="submit" 
            class="btn w-full w-100 btn-sm shadow-bg mt-2 font-semibold text-uppercase" 
            style="background-color: #25D366; color: white;" 
            id="withdrawBtn">
            Withdraw
        </button>
    </div>
</form>

</div>

<script>
    function disableButton() {
        var withdrawBtn = document.getElementById('withdrawBtn');
        withdrawBtn.disabled = true;
        withdrawBtn.textContent = "Processing...";
    }

    document.addEventListener('DOMContentLoaded', function () {
        // Generate a random token
        document.getElementById('uniquekey').value = generateRandomToken();

        // Amount input listener
        const amountInput = document.getElementById('amount');
        const transactionFeeElement = document.getElementById('transactionFee');
        const finalAmountElement = document.getElementById('finalAmount');

        amountInput.addEventListener('input', function () {
            const amount = parseFloat(amountInput.value) || 0;
            const fee = amount * 0.1;
            const finalAmount = amount - fee;

            transactionFeeElement.textContent = fee.toFixed(2);
            finalAmountElement.textContent = finalAmount.toFixed(2);
        });
    });

    function generateRandomToken() {
        var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        var length = 32;
        var token = '';

        for (var i = 0; i < length; i++) {
            token += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        return token;
    }
</script>

<!-- End Request Funds Form -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sahuapp.work/public_html/resources/views/user/withdrawal.blade.php ENDPATH**/ ?>