<?php $__env->startSection('content'); ?>

<?php
    $user = Auth::user();
    $countryCode = $user->country ?? '';

    if ($countryCode == 'Kenya') { // Kenya
        $conversionRate = 130; // 1 USDT = 130 KES
        $currency = 'KES';
    } elseif ($countryCode == 'Zambia') { // Zambia
        $conversionRate = 25; // 1 USDT = 30 ZMW
        $currency = 'ZMW';
    } elseif ($countryCode == 'Tanzania') { // Zambia
        $conversionRate = 2575; // 1 USDT = 30 ZMW
        $currency = 'TZS';
    } elseif ($countryCode == 'Ghana') { // Gana
        $conversionRate = 11; // 1 USDT = 15 GHS
        $currency = 'GHS';
        
    }  elseif ($countryCode == 'Uganda') { // Ghana
        $conversionRate = 3560; // 1 USDT = 30 ZMW
        $currency = 'UGX';
    }  elseif ($countryCode == 'South Sudan') { // Ghana
        $conversionRate = 4512; // 1 USDT = 30 ZMW
        $currency = 'SSP';
    } else { // Default to USD for other countries
        $conversionRate = 1;
        $currency = 'USD';
    }

    $convertedBalance = $user->balance / $conversionRate;
    $min = 1 * $conversionRate;

    $packages = DB::table('packages')->get();
    $img = $packages->get('images');
?>

<?php
// Fetch and count Level 1 downlines (direct referrals)
$firstLevelDownlines = DB::table('users')
    ->where('upline', Auth::user()->ref_code)
    ->get();
     $is_activelv1 = $firstLevelDownlines->sum('investments'); // Using your column directly

     
$firstLevelCount = $firstLevelDownlines->count();


 
// Collect IDs and referral codes of Level 1 downlines
$firstLevelIds = $firstLevelDownlines->pluck('id');
$firstLevelRefCodes = $firstLevelDownlines->pluck('ref_code');



// Initialize arrays for counts and bonuses
$secondLevelCounts = [];
$thirdLevelCounts = [];
$levelBonuses = [];

// Process Level 1 downlines
$secondLevelDownlines = DB::table('users')
    ->whereIn('upline', $firstLevelRefCodes)
    ->get();
 $is_activelv2 = $secondLevelDownlines->sum('investments');
 
 
$secondLevelCount = $secondLevelDownlines->count();


$secondLevelIds = $secondLevelDownlines->pluck('id');
$secondLevelRefCodes = $secondLevelDownlines->pluck('ref_code');

// Process Level 2 downlines
$thirdLevelDownlines = DB::table('users')
    ->whereIn('upline', $secondLevelRefCodes)
    ->get();
    
    $is_activelv3 = $thirdLevelDownlines->sum('investments');
    
    
$thirdLevelCount = $thirdLevelDownlines->count();



$thirdLevelIds = $thirdLevelDownlines->pluck('id');

// Calculate bonuses for Level 2 and Level 3
// Fetch total investments per level
$level1Investment = DB::table('invest')->whereIn('user_id', $firstLevelIds)->sum('capital');
$level2Investment = DB::table('invest')->whereIn('user_id', $secondLevelIds)->sum('capital');
$level3Investment = DB::table('invest')->whereIn('user_id', $thirdLevelIds)->sum('capital');

// Apply bonus percentages
$bonusLevel1 = $level1Investment * 0.15; // 12%
$bonusLevel2 = $level2Investment * 0.02; // 2%
$bonusLevel3 = $level3Investment * 0.01; // 1%

// Total commission from all levels
$totalCommission = $bonusLevel1 + $bonusLevel2 + $bonusLevel3;

$countDownline = $firstLevelCount + $secondLevelCount + $thirdLevelCount;

// Fetch investments for Level 1
$totalInvestLevel1 = DB::table('invest')
    ->whereIn('user_id', $firstLevelIds)
    ->sum('capital');

// Fetch investments for Level 2
$totalInvestLevel2 = DB::table('invest')
    ->whereIn('user_id', $secondLevelIds)
    ->sum('capital');

// Fetch investments for Level 3
$totalInvestLevel3 = DB::table('invest')
    ->whereIn('user_id', $thirdLevelIds)
    ->sum('capital');

// Fetch withdrawals for Level 1
$totalWithdrawalsLevel1 = DB::table('cashouts')
    ->whereIn('phone', $firstLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 2
$totalWithdrawalsLevel2 = DB::table('cashouts')
    ->whereIn('phone', $secondLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 3
$totalWithdrawalsLevel3 = DB::table('cashouts')
    ->whereIn('phone', $thirdLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different
    
    
    
?>

<?php
// Level 1
$level1firstInvestments = DB::table('invest')
    ->select('user_id', 'capital', 'created_at')
    ->whereIn('user_id', $firstLevelIds)
    ->orderBy('created_at', 'asc')
    ->get()
    ->groupBy('user_id')
    ->map(function ($investments) {
        return $investments->first(); // First investment per user
    });

$invst1 = $level1firstInvestments->sum('capital');

// Level 2
$level2firstInvestments = DB::table('invest')
    ->select('user_id', 'capital', 'created_at')
    ->whereIn('user_id', $secondLevelIds)
    ->orderBy('created_at', 'asc')
    ->get()
    ->groupBy('user_id')
    ->map(function ($investments) {
        return $investments->first();
    });

$invst2 = $level2firstInvestments->sum('capital');

// Level 3
$level3firstInvestments = DB::table('invest')
    ->select('user_id', 'capital', 'created_at')
    ->whereIn('user_id', $thirdLevelIds)
    ->orderBy('created_at', 'asc')
    ->get()
    ->groupBy('user_id')
    ->map(function ($investments) {
        return $investments->first();
    });

$invst3 = $level3firstInvestments->sum('capital');

// Bonus calculation
$bonus1 = $invst1 * 0.15; // 15%
$bonus2 = $invst2 * 0.02; // 2%
$bonus3 = $invst3 * 0.01; // 1%
?>
<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>

<!-- Bootstrap JS Bundle with Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

<style>
    body {
        background-color: #001a1a;
        color: white;
        font-family: 'Segoe UI', sans-serif;
    }

    .team-header {
        background-color: #00cc66;
        padding: 12px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        color: black;
    }

    .team-header h5 {
        margin: 0 auto;
        color: #001a1a;
        font-weight: bold;
    }

    .team-card {
        border: 1px solid #00ff99;
        border-radius: 12px;
        padding: 15px;
        background-color: #002b2b;
        margin-bottom: 15px;
        box-shadow: 0 0 10px #00ff99;
    }

    .level-header {
        background-color: #00cc66;
        padding: 8px 12px;
        border-radius: 10px 10px 0 0;
        font-weight: bold;
        color: black;
    }

    .level-body {
        display: flex;
        justify-content: space-between;
        padding: 12px;
    }

    .view-details {
        text-align: right;
        font-size: 14px;
        color: #00ffcc;
        cursor: pointer;
        font-weight: bold;
    }

    .bottom-nav {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background-color: #001a1a;
        display: flex;
        justify-content: space-around;
        padding: 10px 0;
        border-top: 1px solid #00ff99;
    }

    .bottom-nav a {
        color: #00ff99;
        text-align: center;
        font-size: 12px;
        text-decoration: none;
    }

    .bottom-nav i {
        font-size: 18px;
    }

    .modal-content {
        background-color: #002222;
        border-radius: 10px;
        border: 1px solid #00ff99;
        color: white;
    }

    .modal-header {
        border-bottom: 1px solid #00cc99;
    }

    .modal-body table {
        width: 100%;
        color: white;
    }

    .modal-body th, .modal-body td {
        padding: 8px;
        border-bottom: 1px solid #006655;
    }
    
    .downline-row {
        cursor: pointer;
    }
    
    .downline-row:hover {
        background-color: #003333;
    }
</style>

<br>
<hr>
<!-- Team Summary -->
<div class="p-4">
    <div class="team-card text-center mb-4">
        <div class="d-flex justify-content-between px-4">
            <div> 
                <h3><?php echo e($countDownline); ?></h3>
                <small>TEAM SIZE</small>
            </div>
            <div>
                <h3><?php echo e($currency); ?> <?php echo e(number_format($totalCommission * $exchange,2)); ?></h3>
                <small>TOTAL INCOME</small>
            </div>
        </div>
    </div>

    <!-- Level 1 -->
    <div class="team-card">
       <div class="level-header">👶 LEVEL 1</div>
        <div class="level-body">
            <div>
                <strong><?php echo e($firstLevelCount); ?></strong><br>
                <small>MEMBERS</small>
            </div>
            <div>
                <strong><?php echo e($currency); ?> <?php echo e(number_format($bonusLevel1 * $exchange,2)); ?></strong><br>
                <small>COMMISSION</small>
            </div>
        </div>
        <div class="view-details" onclick="loadDownlines(1)">VIEW DETAILS →</div>

    </div>

    <!-- Level 2 -->
    <div class="team-card">
        <div class="level-header">👧 LEVEL 2</div>
        <div class="level-body">
            <div>
                <strong><?php echo e($secondLevelCount); ?></strong><br>
                <small>MEMBERS</small>
            </div>
            <div>
                <strong><?php echo e($currency); ?> <?php echo e(number_format($bonusLevel2 * $exchange,2)); ?></strong><br>
                <small>COMMISSION</small>
            </div>
        </div>
      <div class="view-details" onclick="loadDownlines(2)">VIEW DETAILS →</div>

    </div>

    <!-- Level 3 -->
    <div class="team-card">
        <div class="level-header">🧒 LEVEL 3</div>
        <div class="level-body">
            <div>
                <strong><?php echo e($thirdLevelCount); ?></strong><br>
                <small>MEMBERS</small>
            </div>
            <div>
                <strong><?php echo e($currency); ?> <?php echo e(number_format($bonusLevel3 * $exchange,2)); ?></strong><br>
                <small>COMMISSION</small>
            </div>
        </div>
       <div class="view-details" onclick="loadDownlines(3)">VIEW DETAILS →</div>

    </div>
</div>

<hr>

<!-- Downlines Modal --><div class="modal fade" id="downlinesModal" tabindex="-1" aria-labelledby="downlinesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-sm">Downlines (Level <span id="modalLevel">1</span>)</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div class="table-responsive" style="max-height: 60vh; overflow-y: auto; overflow-x: auto;">
                    <table class="table table-dark table-striped table-sm mb-0">
                        <thead class="sticky-top" style="top: -1px;">
                            <tr class="text-xs">
                                <th class="py-2 px-3 text-nowrap">Name</th>
                                <th class="py-2 px-3 text-nowrap">Phone</th>
                                <th class="py-2 px-3 text-nowrap">Bonus</th>
                                <th class="py-2 px-3 text-nowrap">Status</th>
                            </tr>
                        </thead>
                        <tbody id="downlinesList" class="text-xs">
                            <!-- Level 1 Content (default) -->
                            <?php $__currentLoopData = $firstLevelDownlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $downline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->username ?? 'N/A'); ?></td>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->phone ?? 'N/A'); ?></td>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->bonus_1 * $exchange ?? 'N/A'); ?> </td>
                                <td class="py-2 px-3 text-nowrap">
                                    <?php if($is_activelv1 < 0): ?>
                                        <span class="badge bg-success py-1 px-2">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary py-1 px-2">Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($firstLevelDownlines->isEmpty()): ?>
                            <tr>
                                <td colspan="4" class="text-center py-2 px-3">No downlines yet.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                        
                        <!-- Hidden tables for other levels -->
                        <tbody id="level2Downlines" style="display:none;" class="text-xs">
                            <?php $__currentLoopData = $secondLevelDownlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $downline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->username ?? 'N/A'); ?></td>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->phone ?? 'N/A'); ?></td>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->bonus_2 * $exchange ?? 'N/A'); ?> </td>
                                <td class="py-2 px-3 text-nowrap">
                                    <?php if($is_activelv2 < 0): ?>
                                        <span class="badge bg-success py-1 px-2">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary py-1 px-2">Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($secondLevelDownlines->isEmpty()): ?>
                            <tr>
                                <td colspan="4" class="text-center py-2 px-3">No downlines yet.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                        
                        <tbody id="level3Downlines" style="display:none;" class="text-xs">
                            <?php $__currentLoopData = $thirdLevelDownlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $downline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->username ?? 'N/A'); ?></td>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->phone ?? 'N/A'); ?></td>
                                <td class="py-2 px-3 text-nowrap"><?php echo e($downline->investments  * 0.01 * $exchange ?? 'N/A'); ?> </td>
                                <td class="py-2 px-3 text-nowrap">
                                    <?php if($is_activelv3 < 0): ?>
                                        <span class="badge bg-success py-1 px-2">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary py-1 px-2">Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($thirdLevelDownlines->isEmpty()): ?>
                            <tr>
                                <td colspan="4" class="text-center py-2 px-3">No downlines yet.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer py-2">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
    /* Custom scrollbar styling */
    .table-responsive::-webkit-scrollbar {
        height: 8px;
        width: 8px;
    }
    .table-responsive::-webkit-scrollbar-track {
        background: #2d3748;
    }
    .table-responsive::-webkit-scrollbar-thumb {
        background: #4a5568;
        border-radius: 4px;
    }
    .table-responsive::-webkit-scrollbar-thumb:hover {
        background: #718096;
    }
</style>

<script>
    function loadDownlines(level) {
        // Update modal title
        document.getElementById('modalLevel').textContent = level;
        
        // Hide all tables first
        document.getElementById('downlinesList').style.display = 'none';
        document.getElementById('level2Downlines').style.display = 'none';
        document.getElementById('level3Downlines').style.display = 'none';
        
        // Show the selected level's table
        if(level === 1) {
            document.getElementById('downlinesList').style.display = 'table-row-group';
        } else if(level === 2) {
            document.getElementById('level2Downlines').style.display = 'table-row-group';
        } else if(level === 3) {
            document.getElementById('level3Downlines').style.display = 'table-row-group';
        }
        
        // Show the modal
        const modal = new bootstrap.Modal(document.getElementById('downlinesModal'));
        modal.show();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/nxts.site/resources/views/team/team.blade.php ENDPATH**/ ?>