<?php $__env->startSection('content'); ?>

<!-- Begin Request Funds Form -->
<div class="menu-size mb-5">
    <!-- Personal and vivid description -->
    <div class="alert alert-info mt-3">
        <p><strong>Dear <?php echo e(Auth::user()->name); ?>,</strong></p>
        <p>You're about to initiate a withdrawal from your account at <strong><?php echo e(env('APP_NAME')); ?></strong>. Please specify the amount you wish to withdraw and the phone number where the funds should be sent. You can request funds at any time, but make sure to enter the correct details to ensure a smooth transaction.</p>
        <p>For security purposes, we have generated a unique token for this request. Please double-check your phone number before submitting!</p>
    </div>

    <!-- Form to request funds -->
    <form method="POST" id="withdrawalForm" class="w-full p-4" action="<?php echo e(route('withdraw')); ?>" novalidate>
        <?php echo csrf_field(); ?>
        <input id="uniquekey" type="hidden" name="uniquekey">

        <div class="content mt-3">
            <!-- Phone Input -->
            <div class="form-custom form-label form-icon mb-4">
                <i class="bi bi-person-circle text-lg"></i>
                <label for="phone" class="form-label-always-active color-highlight text-sm">Enter Phone Number</label>
                <span class="text-xs">(required)</span>
                <input 
                    type="tel" 
                    name="phone" 
                    class="form-control rounded-xs mt-2 w-full p-3 text-base" 
                    id="phone" 
                    value="<?php echo e(Auth::user()->phone); ?>" 
                    placeholder="<?php echo e(Auth::user()->phone); ?>" 
                    required 
                    aria-label="Phone number" 
                    pattern="^\+?[0-9]{10,15}$" 
                    title="Please enter a valid phone number (e.g., +254701234567)"
                />
                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger text-sm mt-1"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Amount Input -->
            <div class="form-custom form-label form-icon mb-4">
                <i class="bi bi-cash text-lg"></i>
                <label for="amount" class="form-label-always-active color-highlight text-sm">Amount</label>
                <span class="text-xs">(Currency: KES)</span>
                <input 
                    type="number" 
                    name="amount" 
                    class="form-control rounded-xs mt-2 w-full p-3 text-base" 
                    id="amount" 
                    placeholder="300.00" 
                    required 
                    min="1" 
                    aria-label="Amount"
                    step="0.01"
                />
                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger text-sm mt-1"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Submit Button -->
            <button 
                type="submit" 
                data-bs-dismiss="offcanvas" 
                class="btn w-full w-100 btn-sm shadow-bg mt-2 font-semibold text-uppercase" 
                style="background-color: #25D366; color: white;">
                Withdraw
            </button>
        </div>
    </form>
</div>

<!-- Script for generating unique token -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Generate a random token
        var token = generateRandomToken();

        // Set the token value to the hidden input field
        document.getElementById('uniquekey').value = token;
    });

    // Function to generate a random token
    function generateRandomToken() {
        var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        var length = 32; // Token length
        var token = '';

        for (var i = 0; i < length; i++) {
            token += chars.charAt(Math.floor(Math.random() * chars.length));
        }

        return token;
    }
</script>
<!-- End Request Funds Form -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qubitscube.cfd/public_html/resources/views/user/withdrawal.blade.php ENDPATH**/ ?>