<?php $__env->startSection('content'); ?>

<?php
    $packages = DB::table('packages')->get();
?>

<style>
    /* Card Styles */
    .card-stack {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 20px;
        margin: 20px 0;
    }

    .card-style {
        width: 300px;
        border-radius: 12px;
        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        overflow: hidden;
        background-color: #f8f9fa;
        position: relative;
    }

    .card-style:hover {
        transform: scale(1.05);
        box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.2);
    }

    .card-header {
        background: linear-gradient(135deg, #0062cc, #003d99);
        padding: 15px;
        color: #fff;
        text-align: center;
        font-size: 20px;
        font-weight: bold;
    }

    .card-body {
        padding: 20px;
        text-align: center;
        font-family: Arial, sans-serif;
    }

    .price {
        font-size: 28px;
        font-weight: bold;
        color: #0062cc;
        margin: 10px 0;
    }

    .detail {
        font-size: 16px;
        margin-bottom: 10px;
    }

    .order-button {
        background: #0062cc;
        color: #fff;
        border: none;
        border-radius: 5px;
        padding: 10px 20px;
        font-size: 16px;
        font-weight: bold;
        cursor: pointer;
        text-transform: uppercase;
        transition: background 0.2s;
    }

    .order-button:hover {
        background: #004a99;
    }

    .vip-badge {
        position: absolute;
        top: 10px;
        left: 10px;
        background-color: #ffcc00;
        color: #333;
        font-size: 12px;
        font-weight: bold;
        padding: 5px 10px;
        border-radius: 5px;
        text-transform: uppercase;
        box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2);
    }

    .card-footer {
        background: #f1f1f1;
        padding: 10px;
        text-align: center;
        font-size: 14px;
        color: #555;
        border-top: 1px solid #ddd;
    }

</style>

<!-- Display Notifications -->


<!-- Display Packages -->
<div class="card-stack">
    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="card-style">
            <?php if($pkg->vip): ?>
                <div class="vip-badge">VIP</div>
            <?php endif; ?>
            <div class="card-header">
                <?php echo e($pkg->days); ?> Days Package
            </div>
            <div class="card-body">
                <div class="price">KES <?php echo e(number_format($pkg->price, 2)); ?></div>
                <div class="detail">Daily Income: KES <?php echo e(number_format($pkg->daily_income, 2)); ?></div>
                <button 
                    class="order-button" 
                    onclick="window.location.href='<?php echo e(url('package?p=' . $pkg->id)); ?>'">
                    Order Now
                </button>
            </div>
            <div class="card-footer">
                Price: <?php echo e(number_format($pkg->price, 2)); ?> KES
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qubitscube.cfd/public_html/resources/views/investment.blade.php ENDPATH**/ ?>