<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title><?php echo e(env('APP_NAME')); ?> - Earn through trading and investments</title>
    <link rel="stylesheet" type="text/css" href="public/styles/bootstrap.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link
        href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@500;600;700&family=Roboto:wght@400;500;700&display=swap"
        rel="stylesheet">
    <link rel="manifest" href="public/_manifest.json">
    <meta id="theme-check" name="theme-color" content="#FFFFFF">
    <link rel="apple-touch-icon" sizes="180x180" href="public/app/icons/icon-192x192.png">
</head>

<body class="theme-light">
    <div id="preloader">
        <div class="spinner-border color-highlight" role="status"></div>
    </div>

    <div id="page">
        <?php 
        if(!empty($_GET['ref_code'])){
            $upline = $_GET['ref_code'];
        }else{
            $upline = "mkuu";
        }
        ?>
        <div class="page-content my-0 py-0">
            <div class="card bg-5 card-fixed">
                <div class="card-center mx-3 px-4 py-4 bg-white rounded-m">
                    <h1 class="font-30 font-800 mb-0">BitGoTrust</h1>
                    <p>Create an account</p>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('register')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" value="<?php echo e($upline); ?>" name="upline">

                        <div class="form-custom form-label form-border form-icon mb-3 bg-transparent">
                            <i class="bi bi-person-circle font-13"></i>
                            <input type="text" name="username" class="form-control rounded-xs" id="c1a"
                                placeholder="Username" />
                            <label for="c1a" class="color-theme">Username</label>
                            <span>(required)</span>
                        </div>
                        <div class="form-custom form-label form-border form-icon mb-3 bg-transparent">
                            <i class="bi bi-at font-16"></i>
                            <input type="phone" name="phone" class="form-control rounded-xs" id="c1"
                                placeholder="Phone Number" />
                            <label for="c1" class="color-theme">Phone Number</label>
                            <span>(required)</span>
                        </div>
                        <div class="form-custom form-label form-border form-icon mb-3 bg-transparent">
                            <i class="bi bi-asterisk font-13"></i>
                            <input type="password" name="password" class="form-control rounded-xs" id="c2"
                                placeholder="Choose Password" />
                            <label for="c2" class="color-theme">Choose Password</label>
                            <span>(required)</span>
                        </div>
                        <div class="form-custom form-label form-border form-icon mb-4 bg-transparent">
                            <i class="bi bi-asterisk font-13"></i>
                            <input type="password" name="password_confirmation" class="form-control rounded-xs" id="c3"
                                placeholder="Confirm Password" />
                            <label for="c3" class="color-theme">Choose Password</label>
                            <span>(required)</span>
                        </div>

                        <div class="form-check form-check-custom">
                            <input class="form-check-input" type="checkbox" name="type" value id="c2a">
                            <label class="form-check-label font-12" for="c2a">I agree with the <a href="#">Terms and
                                    Conditions</a>.</label>
                            <i class="is-checked color-highlight font-13 bi bi-check-circle-fill"></i>
                            <i class="is-unchecked color-highlight font-13 bi bi-circle"></i>
                        </div>
                        <button 
                            class="btn btn-full gradient-highlight shadow-bg shadow-bg-s mt-4">Create
                            Account</button>
                        <div class="row">
                            <div class="col-6 text-start">
                                <a href="password/reset" class="font-11 color-theme opacity-40 pt-4 d-block">Forgot
                                    Password?</a>
                            </div>
                            <div class="col-6 text-end">
                                <a href="login" class="font-11 color-theme opacity-40 pt-4 d-block">
                                    Sign In Account</a>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-overlay rounded-0 m-0 bg-black opacity-70"></div>
            </div>
        </div>



    </div>

    <script src="public/scripts/bootstrap.min.js"></script>
    <script src="public/scripts/custom.js"></script>
</body><?php /**PATH /home/uniquesq/bitgotrust.nakaa.com.ng/resources/views/auth/register.blade.php ENDPATH**/ ?>