<?php $__env->startSection('content'); ?>
<?php
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

$userId = Auth::id();

$deposits = DB::table('deposits')
    ->where('username', $userId)
    ->orderByDesc('created_at')
    ->get();

$cashouts = DB::table('cashouts')
    ->where('phone', $userId)
    ->orderByDesc('created_at')
    ->get();

$invests = DB::table('invest')
    ->where('user_id', $userId)
    ->orderByDesc('created_at')
    ->get();

?>

      <style>
        .section-title {
            font-weight: bold;
            font-size: 1.4rem;
            margin: 1rem 0 0.2rem;
        }

        .transaction-container {
            border: 1px solid #ddd;
            border-radius: 5px;
            overflow-x: auto;
            margin-bottom: 1.5rem;
            padding:2px;
        }

        .transaction-row {
            display: grid;
            grid-template-columns: repeat(6, minmax(80px, 1fr));
            font-size: 0.72rem;
            padding: 4px 2px;
            border-bottom: 1px solid #eee;
            white-space: nowrap;
        }

        .transaction-header {
            font-weight: bold;
            background-color: #f1f1f1;
        }

        .no-record {
            font-size: 0.75rem;
            color: #666;
            text-align: center;
            padding: 5px;
        }

        @media (max-width: 576px) {
            .transaction-row {
                font-size: 0.68rem;
                grid-template-columns: repeat(6, minmax(70px, 1fr));
            }
        }
    </style>
<main class="container mt-3">


    
    <div class="transaction-container">
        <div class="section-title">Deposit History</div>
        <div class="transaction-row transaction-header  text-dark">
          
            <div>Method</div>
            <div>Amount</div>
            <div>Status</div>
            <div>Date</div>
            <div></div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="transaction-row">
                
                <div><?php echo e($d->method); ?></div>
                <div>KES <?php echo e(number_format($d->amount, 2)); ?></div>
                <div><?php echo e(ucfirst($d->status)); ?></div>
                <div><?php echo e(\Carbon\Carbon::parse($d->created_at)->format('Y-m-d')); ?></div>
                <div></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="no-record">No deposits found.</div>
        <?php endif; ?>
    </div>

    
    <div class="transaction-container">
        <div class="section-title">Withdrawal History</div>
        <div class="transaction-row transaction-header  text-dark">
           
            <div>Amount</div>
            <div>Phone</div>
            <div>Status</div>
           
            <div>Date</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $cashouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="transaction-row">
                
                <div>KES <?php echo e(number_format($c->amount, 2)); ?></div>
                <div><?php echo e($c->phone); ?></div>
                <div><?php echo e(ucfirst($c->status)); ?></div>
                
                <div><?php echo e(\Carbon\Carbon::parse($c->created_at)->format('Y-m-d')); ?></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="no-record">No withdrawals found.</div>
        <?php endif; ?>
    </div>



    
    <div class="transaction-container">
        <div class="section-title">Investment History</div>
        <div class="transaction-row transaction-header text-dark" style="font-size:10px;" >
            
           
            <div>Period</div>
            <div>Capital</div>
            <div>Returns</div>
            <div>Next Pay</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="transaction-row">
               
                
                <div><?php echo e($i->period); ?>days</div>
                <div>KES <?php echo e(number_format($i->capital, 2)); ?></div>
                <div>KES <?php echo e(number_format($i->returns, 2)); ?></div>
                <?php
                    $now = Carbon::now();
                    $next = Carbon::parse($i->next_payment);
                    $remainingSeconds = $now->diffInSeconds($next, false); // Allow negative
                ?>
                
                <div>
                    <span class="countdown" data-seconds="<?php echo e(max(0, $remainingSeconds)); ?>">
                        Loading...
                    </span>
                </div>

                


            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="no-record">No investments found.</div>
        <?php endif; ?>
    </div>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const countdowns = document.querySelectorAll(".countdown");

        countdowns.forEach(el => {
            let secondsLeft = parseInt(el.dataset.seconds);

            function updateCountdown() {
                if (secondsLeft <= 0) {
                    el.innerHTML = "Processing...";
                    return;
                }

                const hours = Math.floor(secondsLeft / 3600);
                const minutes = Math.floor((secondsLeft % 3600) / 60);
                const seconds = secondsLeft % 60;

                el.innerHTML = `${hours.toString().padStart(2, '0')}h ${minutes.toString().padStart(2, '0')}m ${seconds.toString().padStart(2, '0')}s`;

                secondsLeft--;
                setTimeout(updateCountdown, 1000);
            }

            updateCountdown();
        });
    });
</script>



</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/asheq.top/resources/views/user/accounts.blade.php ENDPATH**/ ?>