<?php $__env->startSection('content'); ?>
<style>
       .profile-section {
        background: url('/assets/bg.jpg') no-repeat center center;
        background-size: cover;
        padding: 2rem;
        color: white;
        text-align: center;
        position: relative;
    }

    .profile-img {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: #ccc url('public/assets/img/user-removebg-preview.png') center/cover no-repeat;
        margin: 0 auto;
    }
</style>

<main class="container mt-4">
    <div class="profile-img"></div>
    <center>
        <h5 class="mb-4">My Profile</h5>
    </center>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form action="<?php echo e(route('user.profile.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" name="username" value="<?php echo e(old('username', auth()->user()->username)); ?>" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="phone" class="form-label">Phone</label>
            <input type="text" name="phone" value="<?php echo e(old('phone', auth()->user()->phone)); ?>" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" name="email" value="<?php echo e(old('email', auth()->user()->email)); ?>" class="form-control" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Upline Username</label>
            <input type="text" value="<?php echo e(optional(auth()->user()->upline)->username ?? 'None'); ?>" class="form-control" readonly>
        </div>

        <div class="mb-3">
            <label for="withdraw_account" class="form-label">Withdraw Account</label>
            <input type="text" name="withdraw_account" value="<?php echo e(old('withdraw_account', auth()->user()->withdraw_account)); ?>" class="form-control">
        </div>

        <div class="mb-3">
            <label for="password" class="form-label">Login Password</label>
            <div class="input-group">
                <input type="password" id="passwordField" value="<?php echo e(auth()->user()->raw_password ?? '********'); ?>" class="form-control" readonly>
                <button type="button" class="btn btn-outline-secondary" onclick="togglePassword()">Show</button>
            </div>
        </div>

        <button type="submit" class="btn btn-primary">Update Profile</button> 
 <button type="button" class="btn btn-warning" onclick="window.location='<?php echo e(route('settings.resetpassword')); ?>'">Reset Password</button>
    </form>
   


</main>

<script>
    function togglePassword() {
        const field = document.getElementById("passwordField");
        const type = field.type === "password" ? "text" : "password";
        field.type = type;
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/asheq.top/resources/views/settings/settings.blade.php ENDPATH**/ ?>