<?php $__env->startSection('content'); ?>
    <div class="card shadow-lg rounded-lg mx-auto my-5 p-4" style="max-width: 750px;">
        <!-- Header Section -->
        <div class="d-flex justify-content-between mb-4">
            <a href="/home" class="text-primary d-flex align-items-center">
                <i class="bi bi-chevron-left"></i>
                <span class="ms-2">Back to Home</span>
            </a>
        </div>

        <div class="content">
            <!-- Personal Information Section -->
            <section class="mb-5">
                <h5 class="fw-semibold text-dark mb-3">Personal Information</h5>
                <div class="mb-4">
                    <label for="username" class="form-label text-muted">Username</label>
                    <input type="text" id="username" class="form-control" value="<?php echo e(Auth::user()->username); ?>" placeholder="Enter your username" />
                    <div class="form-text">This is your display name.</div>
                </div>

                <div class="mb-4">
                    <label for="address" class="form-label text-muted">Address</label>
                    <input type="text" id="address" class="form-control" placeholder="Enter your address" />
                    <div class="form-text">Provide your current address.</div>
                </div>
            </section>

            <!-- Default Settings Section -->
            <section class="mb-5">
                <h5 class="fw-semibold text-dark mb-3">Default Settings</h5>
                <div class="mb-4">
                    <label for="account" class="form-label text-muted">Default Account</label>
                    <select class="form-select" id="account">
                        <option value="0" selected>Investment Account</option>
                    </select>
                </div>
            </section>

         <!-- Account Security Section -->
        <section class="mb-5">
            <h5 class="fw-semibold text-dark mb-3">Account Security</h5>
             <!-- Success Message -->
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
        
            <!-- Error Messages -->
            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <form action="<?php echo e(route('password.change')); ?>" method="POST">
                <?php echo csrf_field(); ?> <!-- CSRF token for security -->
                <div class="mb-4">
                    <label for="phone" class="form-label text-muted">Phone Number</label>
                    <input type="tel" id="phone" name="phone" class="form-control" value="<?php echo e(Auth::user()->phone); ?>" readonly />
                    <div class="form-text">We will use this for account recovery.</div>
                </div>
        
                <div class="mb-4">
                    <label for="current-password" class="form-label text-muted">Current Password</label>
                    <input type="password" id="current-password" name="current_password" class="form-control" placeholder="Enter your current password" required />
                    <div class="form-text">Ensure your current password is correct.</div>
                </div>
        
                <div class="mb-4">
                    <label for="new-password" class="form-label text-muted">New Password</label>
                    <input type="password" id="new-password" name="new_password" class="form-control" placeholder="Enter your new password" required />
                    <div class="form-text">Choose a strong password to protect your account.</div>
                </div>
        
                <div class="mb-4">
                    <label for="new-password-confirmation" class="form-label text-muted">Confirm New Password</label>
                    <input type="password" id="new-password-confirmation" name="new_password_confirmation" class="form-control" placeholder="Confirm your new password" required />
                </div>
        
                <!-- Apply Settings Button -->
                <div class="mt-4">
                    <button class="btn btn-primary w-100 py-3" type="submit">
                        Apply Settings
                    </button>
                </div>
            </form>
        </section>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qubitscube.cfd/public_html/resources/views/profile.blade.php ENDPATH**/ ?>