<?php $__env->startSection('content'); ?>
 <div class="container mt-5">
        <div class="card">
            <?php if(Auth::user()->survey == 'pending'): ?>
            <div class="card-header">
                <h4 class="card-text font-bold fs-bold"><?php echo e($survey->title); ?></h4>
                <p class="card-text"><?php echo e($survey->description); ?></p>
            </div>
            <div class="card-body">
                
                <form action="/survey/submit" method="POST">
                    <?php echo csrf_field(); ?>

                    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-4">
                            <label for="question-<?php echo e($question->id); ?>" class="form-label">
                                <strong><?php echo e($loop->iteration); ?>. <?php echo e($question->question_text); ?></strong>
                            </label>

                            <?php if($question->question_type == 'multiple-choice'): ?>
                                <div class="form-check">
                                    <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="questions[<?php echo e($question->id); ?>]" value="<?php echo e($answer->id); ?>" id="answer-<?php echo e($answer->id); ?>">
                                            <label class="form-check-label" for="answer-<?php echo e($answer->id); ?>">
                                                <?php echo e($answer->answer_text); ?>

                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php elseif($question->question_type == 'text'): ?>
                                <textarea class="form-control" id="question-<?php echo e($question->id); ?>" name="questions[<?php echo e($question->id); ?>]" rows="4" placeholder="Your response"></textarea>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                    <button type="submit" class="btn btn-primary">Submit Survey</button>
                </form>
               
            </div>
             <?php else: ?>
              <div class="card-footer">
                  <p>No survey Available Till Next Week</p>
              </div>
                <?php endif; ?>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/qubitscube.cfd/public_html/resources/views//survey.blade.php ENDPATH**/ ?>