<?php $__env->startSection('content'); ?>
        <!-- Header ends -->
        <?php 
        
        // In your controller or wherever you need this query
     $transactions = \DB::table('deposits')
                    ->select('deposits.created_at as date', 'deposits.amount','deposits.status',  \DB::raw("'deposit' as type"))
                    ->where('deposits.username', '=', Auth::user()->username)
                    ->union(
                        \DB::table('cashouts')
                            ->select('cashouts.created_at as date', 'cashouts.amount','cashouts.status', \DB::raw("'cashout' as type"))
                            ->where('cashouts.username', '=', Auth::user()->username)
                    )
                    ->latest('date') // Order by the 'date' column in descending order
                    ->limit(4)       // Limit to the latest 4 records
                    ->get();

        
        ?>
        <!-- main page content -->
        <div class="mt-3 container">
            <?php if($transactions->count() > 0): ?>
            <div class="row mb-3">
                <div class="col">
                    <h6 class="title">Transactions<br><small class="fw-normal text-muted">Today, <?php echo e(date("Y-m-d")); ?></small>
                    </h6>
                </div>
                <div class="col-auto align-self-center">
                    <a href="deposit" class="small">Recharge</a>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body p-0">
                            <ul class="list-group list-group-flush bg-none">
                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item rounded">
                                    <div class="row">
                                        <div class="col align-self-center ps-0">
                                            <p class="text-secondary size-10 mb-0"><?php echo e($trx->type); ?></p>
                                            <p>MPESA</p>
                                        </div>
                                        <div class="col align-self-center text-end">
                                            <p class="text-secondary text-muted size-10 mb-0"><?php echo e(\Carbon\Carbon::parse($trx->date)->addHours(3)->toDayDateTimeString()); ?></p>
                                            <p><?php if($trx->type == "cashout"): ?> <b>-</b> <?php else: ?><b>+</b> <?php endif; ?><?php echo e($trx->amount); ?></p>
                                            <code><b><?php echo e($trx->status); ?></b></code>
                                        </div>
                                    </div>
                                </li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php else: ?>
            <center>
                <p>No Transactions yet</p>
            </center>
           <?php endif; ?>
        </div>
        <!-- main page content ends -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uniquesq/clarityinvestment.antgpt.africa/resources/views/transactions.blade.php ENDPATH**/ ?>