<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="generator" content="">
    <title><?php echo e(env('APP_NAME')); ?></title>

    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- bootstrap icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">

    
    <link href="<?php echo e(env('APP_RES')); ?>/bootstrap/css/bootstrap.css" rel="stylesheet" >
    <link href="<?php echo e(env('APP_RES')); ?>/assets/css/style.css" rel="stylesheet" >
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />

    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
       <!--tailwind css 3-->
</head>

<body class="body-scroll" data-page="addmoney">

  

    <main class="h-screen mt-2 pt-2">

     <!-- Header -->
     <header class="fixed top-0 left-0 right-0 text-white  p-4 z-10">
        <div class="flex items-center justify-between">
            <div class="">
                <a href="home">
                    <button type="button" class="bg-gray-100 shadow rounded-lg text-gray-700 px-2 font-bold">
                        <i class="bi bi-arrow-left"></i>
                    </button>
                </a>
            </div>

        </div>
    </header>
        <!-- Header ends -->
        <?php 
        
        // In your controller or wherever you need this query
     $transactions = \DB::table('deposits')
                    ->select('deposits.created_at as date', 'deposits.amount','deposits.status',  \DB::raw("'deposit' as type"))
                    ->where('deposits.username', '=', Auth::user()->username)
                    ->union(
                        \DB::table('cashouts')
                            ->select('cashouts.created_at as date', 'cashouts.amount','cashouts.status', \DB::raw("'cashout' as type"))
                            ->where('cashouts.username', '=', Auth::user()->username)
                    )
                    ->latest('date') // Order by the 'date' column in descending order
                    ->limit(4)       // Limit to the latest 4 records
                    ->get();

        
        ?>
        <!-- main page content -->
        <div class="mt-20 container">
            <?php if($transactions->count() > 0): ?>
            <div class="row mb-3">
                <div class="col">
                    <h6 class="title">Transactions<br><small class="fw-normal text-muted">Today, <?php echo e(date("Y-m-d")); ?></small>
                    </h6>
                </div>
                <div class="col-auto align-self-center">
                    <a href="deposit" class="small">Recharge</a>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body p-0">
                            <ul class="list-group list-group-flush bg-none">
                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item">
                                    <div class="row">
                                        <div class="col align-self-center ps-0">
                                            <p class="text-secondary size-10 mb-0"><?php echo e($trx->type); ?></p>
                                            <p>MPESA</p>
                                        </div>
                                        <div class="col align-self-center text-end">
                                            <p class="text-secondary text-muted size-10 mb-0"><?php echo e(\Carbon\Carbon::parse($trx->date)->addHours(3)->toDayDateTimeString()); ?></p>
                                            <p><?php if($trx->type == "cashout"): ?> <b>-</b> <?php else: ?><b>+</b> <?php endif; ?><?php echo e($trx->amount); ?></p>
                                            <code><b><?php echo e($trx->status); ?></b></code>
                                        </div>
                                    </div>
                                </li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php else: ?>
            <center>
                <p>No Transactions yet</p>
            </center>
           <?php endif; ?>
        </div>
        <!-- main page content ends -->


    </main>
    <!-- Page ends-->

</body>

</html><?php /**PATH /home/xexdzgmh/schwab.cashgrowdailyinvestment.com.ng/resources/views/transactions.blade.php ENDPATH**/ ?>