<!DOCTYPE html>
<html lang="en" class="light-mode layout-modern" dir="ltr">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo e(config('app.name')); ?></title>

  <!-- Favicon -->
  <link rel="icon" href="public/assets/img/favicon/favicon.ico" type="image/x-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.2/css/boxicons.min.css" rel="stylesheet">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">

  <!-- Wrapper for auth layout with gradient background -->
  <div class="d-flex justify-content-center align-items-center min-vh-100 p-4" style="background: linear-gradient(to bottom right, #cc66ff, #ff4dff);">
    <!-- Auth Card -->
    <div class="card shadow-sm rounded-3 p-4 w-100" style="max-width: 400px;">
      <!-- Brand Logo -->
      <div class="text-center mb-4">
        <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="currentColor" class="bi bi-layers-fill" viewBox="0 0 16 16">
          <path d="M8.309.791a1 1 0 0 0-.618 0l-7 3a1 1 0 0 0 0 1.82l7 3a1 1 0 0 0 .618 0l7-3a1 1 0 0 0 0-1.82l-7-3z" />
          <path d="M.11 7.165a1 1 0 0 1 .657-.924l7-3a1 1 0 0 1 .618 0l7 3a1 1 0 0 1 0 1.82l-7 3a1 1 0 0 1-.618 0l-7-3a1 1 0 0 1-.657-.896z" />
        </svg>
      </div>

      <!-- Title -->
      <h5 class="text-center mb-4"><?php echo e(config('app.name')); ?></h5>

      <!-- Content Section (Dynamic) -->
      <main>
        <?php echo $__env->yieldContent('content'); ?>
      </main>

      <!-- Footer Section -->
      <div class="text-center mt-4">
        <p class="mb-0 text-muted">© <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
        <a href="#" class="text-success">Privacy Policy</a>
      </div>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<?php /**PATH /home/qubitscube.cfd/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>