<?php $__env->startSection('content'); ?>
    <div class="container mt-5">
        <div class="text-center">
            <h2>Deposit via M-Pesa Send Money</h2>
        </div>
        <div class="row justify-content-center mt-4">
            <div class="col-md-6">
                <div class="card p-4 shadow">
                    <div class="form-group">
                        <label for="depositNumber">Deposit Number:</label>
                        <div class="input-group">
                            <input type="text" id="depositNumber" class="form-control"
                                   value="<?php echo e(env('DEPOSIT_NUMBER')); ?>" readonly>
                            <div class="input-group-append">
                                <button id="copyButton" class="btn btn-primary" onclick="copyDepositNumber()">
                                    <i class="fas fa-copy"></i> Copy
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- Instructions Section -->
                    <div class="mt-4">
                        <h5>Instructions:</h5>
                        <ol>
                            <li>Open M-Pesa menu on your phone.</li>
                            <li>Select 'Send Money'.</li>
                            <li>Enter Number: <?php echo e(env('DEPOSIT_NUMBER')); ?>.</li>
                            <li>Enter Confrim Name: <?php echo e(env('DEPOSIT_NAME')); ?>.</li>
                            <li>Enter Amount and confirm the transaction.</li>
                            <li>Enter your M-Pesa PIN to authorize.</li>
                            <li>Wait for transaction confirmation SMS.</li>
                        </ol>
                        <p class="mt-3">For assistance, contact our support team.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SweetAlert Library for Notification -->
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    
    <script>
        function copyDepositNumber() {
            var depositNumber = document.getElementById('depositNumber');
            depositNumber.select();
            document.execCommand('copy');
    
            // Display SweetAlert notification
            showCopiedNotification();
        }

        function showCopiedNotification() {
            swal({
                title: "Link Copied!",
                text: "Your deposit link has been copied to the clipboard.",
                icon: "success",
                button: "OK",
            });
        }
    </script>
<?php $__env->stopSection(); ?>













<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uniquesq/schwab.cch-hub.top/resources/views/user/deposit.blade.php ENDPATH**/ ?>