<?php $__env->startSection('content'); ?>

<?php
$jobs = DB::table('invest')->where('user_id', Auth::user()->id)->get();
?>
<br />

<div class="card">
  <div class="card-header">
      <h2 class="text-center">Job Levels Subscribed</h2>
  </div>
  <div class="table-responsive px-0">
    <table class="table table-bordered table-striped" >
        <thead class="table-dark">
            <tr>
        
                <th>Amount</th>
                
                 <th>Daily Income (Salary)</th>
                <th>Days Paid</th>
               
                <th>Status</th>
                <th>Start Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            <?php
                $package = DB::table('packages')->where('price', $job->capital)->first();
            ?>
                <tr>
                    <td><?php echo e($package->vip ?? 40); ?></td>
                    <td><?php echo e(number_format($job->returns, 2)); ?></td>
                    <td><?php echo e($job->days_paid); ?>/ <?php echo e($package->days ?? 40); ?></td>
                    <td>
                        <?php if($job->status == 1): ?>
                            <span class="badge bg-success">Active</span>
                        <?php elseif($job->status == 2): ?>
                            <span class="badge bg-danger">Expired</span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Unknown</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php echo e(\Carbon\Carbon::parse($job->created_at)->addHours(3)); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
    
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/cdp24.site/resources/views/user/jobhistory.blade.php ENDPATH**/ ?>