<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover, shrink-to-fit=no">
    <meta name="description" content="Suha - Multipurpose E-commerce Mobile HTML Template">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#625AFA">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <!-- The above tags *must* come first in the head, any other head content must come *after* these tags -->
    <!-- Title -->
    <title>Suha - review products and get paid</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&amp;display=swap"
        rel="stylesheet">
    <!-- Favicon -->
    <link rel="icon" href="public/assets/img/icons/icon-72x72.png">
    <!-- Apple Touch Icon -->
    <link rel="apple-touch-icon" href="public/assets/img/icons/icon-96x96.png">
    <link rel="apple-touch-icon" sizes="152x152" href="public/assets/img/icons/icon-152x152.png">
    <link rel="apple-touch-icon" sizes="167x167" href="public/assets/img/icons/icon-167x167.png">
    <link rel="apple-touch-icon" sizes="180x180" href="public/assets/img/icons/icon-180x180.png">
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="public/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/css/tabler-icons.min.css">
    <link rel="stylesheet" href="public/assets/css/animate.css">
    <link rel="stylesheet" href="public/assets/css/owl.carousel.min.css">
    <link rel="stylesheet" href="public/assets/css/magnific-popup.css">
    <link rel="stylesheet" href="public/assets/css/nice-select.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Stylesheet -->
    <link rel="stylesheet" href="public/assets/style.css">

    <!-- Web App Manifest -->
    <link rel="manifest" href="manifest.json">
   
</head>

<body>
          <?php
            $notifications = DB::table('notifications')->where('user_id', Auth::user()->id)->where('status', '!=', 'archived')->get();
            ?>
    <!-- Preloader-->
    <div class="preloader" id="preloader">
        <div class="spinner-grow text-secondary" role="status">
            <div class="sr-only"></div>
        </div>
    </div>
    <!-- Header Area -->
    <div class="header-area" id="headerArea">
        <div class="container h-100 d-flex align-items-center justify-content-between d-flex rtl-flex-d-row-r">
            <!-- Logo Wrapper -->
            <div class="logo-wrapper"><a href="home"><img src="public/assets/img/core-img/logo-small.png" alt=""></a>
            </div>
            <div class="navbar-logo-container d-flex align-items-center">
                <!-- Cart Icon -->
                <div class="cart-icon-wrap"><a href="notifications"><i class="ti ti-bell"></i><span><?php echo e($notifications->count()); ?></span></a>
                </div>
                <!-- User Profile Icon -->
                <div class="user-profile-icon ms-2"><a href="profile"><img src="public/user.png"
                            alt=""></a></div>
                <!-- Navbar Toggler -->
                <div class="suha-navbar-toggler ms-2" data-bs-toggle="offcanvas" data-bs-target="#suhaOffcanvas"
                    aria-controls="suhaOffcanvas">
                    <div><span></span><span></span><span></span></div>
                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas offcanvas-start suha-offcanvas-wrap" tabindex="-1" id="suhaOffcanvas"
        aria-labelledby="suhaOffcanvasLabel">
        <!-- Close button-->
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        <!-- Offcanvas body-->
        <div class="offcanvas-body">
            <!-- Sidenav Profile-->
            <div class="sidenav-profile">
                <div class="user-profile"><img src="public/user.png" alt=""></div>
                <div class="user-info">
                    <h5 class="user-name mb-1 text-white"><?php echo e(Auth::user()->username); ?></h5>
                    <p class="available-balance text-white">Current Balance KES.<span class="counter"><?php echo e(Auth::user()->balance); ?></span></p>
                </div>
            </div>
         
            <!-- Sidenav Nav-->
            <ul class="sidenav-nav ps-0">
                <li><a href="home"><i class="ti ti-home"></i>Home</a></li>
                <li><a href="deposit"><i class="ti ti-credit-card"></i>Deposit</a></li>
                <li><a href="withdraw"><i class="ti ti-download"></i>Cashout</a></li>
            
               
                <li class=""><a href="vip"><i class="ti ti-building-store"></i>Job list</a>
                </li>
                <li><a href="profile"><i class="ti ti-user"></i>My Profile</a></li>
                <li><a href="task"><i class="ti ti-notebook"></i>Pending Tasks</a></li>
                <li class="">
                    <a href="transactions"><i class="ti ti-heart"></i>Transactions</a>
                </li>
                 <li><a href="notifications"><i class="ti ti-bell-ringing <?php if($notifications->count() > 0): ?> lni-tada-effect <?php endif; ?> "></i>Notifications
                  <?php if($notifications->count() > 0): ?> <span class="ms-1 badge badge-warning"><?php echo e($notifications->count()); ?></span>  <?php endif; ?>
                </a>
                </li>
                <li><a href="downlines"><i class="ti ti-adjustments-horizontal"></i>Teams</a></li>
                <li><a href="logout"><i class="ti ti-logout"></i>Sign Out</a></li>
            </ul>
        </div>
    </div>
   
    <div class="page-content-wrapper">

        <!-- main page content -->
        <div class="main-container container">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- main page content ends -->

    </div>
    <!-- Internet Connection Status-->
    <div class="internet-connection-status" id="internetStatus"></div>
    <!-- Footer Nav-->
    <div class="footer-nav-area" id="footerNav">
        <div class="suha-footer-nav">
            <ul class="h-100 d-flex align-items-center justify-content-between ps-0 d-flex rtl-flex-d-row-r">
                <li><a href="home"><i class="ti ti-home"></i>Home</a></li>
                <li><a href="deposit"><i class="ti ti-credit-card"></i>Deposit</a></li>
                <li><a href="vip"><i class="ti ti-basket"></i>Jobs</a></li>
                <li><a href="withdraw"><i class="ti ti-download"></i>Withdraw</a></li>
                <li><a href="task"><i class="ti ti-heart"></i>Task</a></li>
            </ul>
        </div>
    </div>
    <!-- All JavaScript Files-->
    <script src="public/assets/js/bootstrap.bundle.min.js"></script>
    <script src="public/assets/js/jquery.min.js"></script>
    <script src="public/assets/js/waypoints.min.js"></script>
    <script src="public/assets/js/jquery.easing.min.js"></script>
    <script src="public/assets/js/owl.carousel.min.js"></script>
    <script src="public/assets/js/jquery.magnific-popup.min.js"></script>
    <script src="public/assets/js/jquery.counterup.min.js"></script>
    <script src="public/assets/js/jquery.countdown.min.js"></script>
    <script src="public/assets/js/jquery.passwordstrength.js"></script>
    <script src="public/assets/js/jquery.nice-select.min.js"></script>
    <script src="public/assets/js/theme-switching.js"></script>
    <script src="public/assets/js/no-internet.js"></script>
    <script src="public/assets/js/active.js"></script>
    <script src="public/assets/js/pwa.js"></script>
</body>

</html><?php /**PATH /home/sahuapp.work/public_html/resources/views/layouts/main.blade.php ENDPATH**/ ?>