<?php $__env->startSection('content'); ?>

<style>
    .tab-content {
        padding: 20px;
        border: 1px solid #ccc;
        border-radius: 5px;
    }

    .scrollable-tabs {
        overflow-x: auto; /* Enable horizontal scrolling */
        white-space: nowrap; /* Prevent tabs from wrapping to the next line */
    }

    .nav-tabs .nav-link {
        display: inline-block; /* Make each tab an inline block for better layout */
    }

    .infographic {
        max-width: 100%;
        height: auto;
        margin: 20px 0;
    }

    .quote {
        font-style: italic;
        color: #555;
        border-left: 4px solid #ccc;
        padding-left: 10px;
        margin: 20px 0;
    }

    .resource-list {
        list-style-type: none;
        padding: 0;
    }

    .resource-list li {
        margin: 10px 0;
    }
</style>

<div class="container mt-5">
    <h4 class="mb-2">Forex Trading Classes</h4>
   <div class="scrollable-tabs">
        <div class="nav nav-tabs" id="nav-tab" role="tablist">
            <button class="nav-link active" id="nav-introduction-tab" data-bs-toggle="tab" data-bs-target="#nav-introduction" type="button" role="tab" aria-controls="nav-introduction" aria-selected="true">Introduction</button>
            <button class="nav-link" id="nav-basics-tab" data-bs-toggle="tab" data-bs-target="#nav-basics" type="button" role="tab" aria-controls="nav-basics" aria-selected="false">Forex Basics</button>
            <button class="nav-link" id="nav-strategies-tab" data-bs-toggle="tab" data-bs-target="#nav-strategies" type="button" role="tab" aria-controls="nav-strategies" aria-selected="false">Trading Strategies</button>
            <button class="nav-link" id="nav-analysis-tab" data-bs-toggle="tab" data-bs-target="#nav-analysis" type="button" role="tab" aria-controls="nav-analysis" aria-selected="false">Market Analysis</button>
            <button class="nav-link" id="nav-videos-tab" data-bs-toggle="tab" data-bs-target="#nav-videos" type="button" role="tab" aria-controls="nav-videos" aria-selected="false">Videos</button>
            <button class="nav-link" id="nav-resources-tab" data-bs-toggle="tab" data-bs-target="#nav-resources" type="button" role="tab" aria-controls="nav-resources" aria-selected="false">Resources</button>
        </div>
    </div>
    <div class="tab-content mt-3" id="nav-tabContent">
        <div class="tab-pane fade show active" id="nav-introduction" role="tabpanel" aria-labelledby="nav-introduction-tab">
            <h3>Introduction to Forex</h3>
            <p>The foreign exchange market, or Forex, is a global decentralized market for trading currencies. It is the largest and most liquid market in the world, with trillions of dollars traded daily. Understanding how the Forex market operates is crucial for anyone looking to succeed in trading.</p>
            <img src="https://media.istockphoto.com/id/1323542329/photo/woman-is-checking-bitcoin-price-chart-on-digital-exchange-on-smartphone-cryptocurrency-future.jpg?s=1024x1024&w=is&k=20&c=N6jOUfAhLtwV8cHmanA7qY55Sv2jVqjhwHvNMpTgwhg=" alt="Introduction to Forex" class="infographic">
            <p class="quote">"Trading is not about being right or wrong; it’s about how much money you make when you’re right and how much you lose when you’re wrong." - George Soros</p>
        </div>
        <div class="tab-pane fade" id="nav-basics" role="tabpanel" aria-labelledby="nav-basics-tab">
            <h3>Forex Basics</h3>
            <p>Understanding the basics of Forex trading is crucial for anyone looking to enter the market. This includes knowing currency pairs, pips, lots, and leverage.</p>
            <ul>
                <li><strong>Currency Pairs:</strong> Forex is traded in pairs, such as EUR/USD or GBP/JPY.</li>
                <li><strong>Pips:</strong> A pip is the smallest price move that a given exchange rate can make based on market convention.</li>
                <li><strong>Leverage:</strong> This allows traders to control a larger position than their actual capital.</li>
            </ul>
            <img src="https://media.istockphoto.com/id/1323542329/photo/woman-is-checking-bitcoin-price-chart-on-digital-exchange-on-smartphone-cryptocurrency-future.jpg?s=1024x1024&w=is&k=20&c=N6jOUfAhLtwV8cHmanA7qY55Sv2jVqjhwHvNMpTgwhg=" alt="Forex Basics" class="infographic">
        </div>
        <div class="tab-pane fade" id="nav-strategies" role="tabpanel" aria-labelledby="nav-strategies-tab">
            <h3>Trading Strategies</h3>
            <p>Successful Forex trading requires well-defined strategies, which may include technical analysis, fundamental analysis, and risk management techniques.</p>
            <p>Here are some popular trading strategies:</p>
            <ul>
                <li><strong>Scalping:</strong> Quick trades to capitalize on small price changes.</li>
                <li><strong>Day Trading:</strong> Buying and selling within the same trading day.</li>
                <li><strong>Swing Trading:</strong> Holding trades for several days to capitalize on expected price moves.</li>
            </ul>
        </div>
        <div class="tab-pane fade" id="nav-analysis" role="tabpanel" aria-labelledby="nav-analysis-tab">
            <h3>Market Analysis</h3>
            <p>Market analysis in Forex can be done using two primary methods: technical analysis and fundamental analysis. Both approaches are important for making informed trading decisions.</p>
            <h4>Technical Analysis</h4>
            <p>This involves analyzing price charts and using indicators to forecast future price movements.</p>
            <h4>Fundamental Analysis</h4>
            <p>This involves evaluating economic, political, and social factors that can impact currency values.</p>
        </div>
        <div class="tab-pane fade" id="nav-videos" role="tabpanel" aria-labelledby="nav-videos-tab">
            <h3>Educational Videos</h3>
            <p>Here are some helpful videos to enhance your understanding of Forex trading:</p>
            <iframe width="100%" height="315" src="https://www.youtube.com/embed/i5OZQQWj5-I?si=8MCJxxA1bmV35daF" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
            <iframe width="100%" height="315" src="https://www.youtube.com/embed/_YVQN6_nkfs?si=5LMZieYSViL40OSZ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </div>
        <div class="tab-pane fade" id="nav-resources" role="tabpanel" aria-labelledby="nav-resources-tab">
            <h3>Additional Resources</h3>
            <p>Explore these resources to deepen your Forex knowledge:</p>
            <ul class="resource-list">
                <li><a href="https://www.investopedia.com/terms/f/forex.asp" target="_blank">Investopedia: Forex Trading</a></li>
                <li><a href="https://www.babypips.com/" target="_blank">BabyPips: Forex Education</a></li>
                <li><a href="https://www.forex.com/en-us/education/" target="_blank">Forex.com: Educational Resources</a></li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/afflixnet.online/public_html/resources/views/forex.blade.php ENDPATH**/ ?>