<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title><?php echo e(env('APP_NAME')); ?> - True Financial partner</title>
    <link rel="stylesheet" type="text/css" href="public/styles/bootstrap.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link
        href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@500;600;700&family=Roboto:wght@400;500;700&display=swap"
        rel="stylesheet">
    <link rel="manifest" href="public/_manifest.json">
    <meta id="theme-check" name="theme-color" content="#FFFFFF">
    <link rel="apple-touch-icon" sizes="180x180" href="public/app/icons/icon-192x192.png">
</head>

<body class="theme-light">
    <div id="preloader">
        <div class="spinner-border color-highlight" role="status"></div>
    </div>

    <div id="page">

        <div class="page-content ">
        <!-- menu-size will be the dimension of your menu. If you set it to smaller than your content it will scroll-->
        <div class="menu-size" style="height:90%;">
            <div class="d-flex mx-3 mt-3 py-1">
                <div class="align-self-center">
                    <h1 class="mb-0">Activate Account</h1>
                </div>
                <div class="align-self-center ms-auto">
                    <a href="home" class="ps-4 shadow-0 me-n2" data-bs-dismiss="offcanvas">
                        <i class="bi bi-x color-red-dark font-26 line-height-xl"></i>
                    </a>
                </div>
            </div>
            <div class="divider divider-margins mt-3"></div>
             <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
            <?php endif; ?>
            <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
            <?php endif; ?>
             <?php if(session('error')): ?>
            <div class="alert alert-success">
                <?php echo e(session('error')); ?>

            </div>
            <?php endif; ?>
        
             <form method="post" action="<?php echo e(route('depositing')); ?>">
                 <?php echo csrf_field(); ?>
            <div class="content mt-0">
               
                   
                <div class="form-custom form-label form-icon">
                    <i class="bi bi-wallet2 font-14"></i>
                    <select class="form-select rounded-xs" id="c6" aria-label="Floating label select example">
                        <option selected>Mpesa Safaricom</option>
                    </select>
                    <label for="c6" class="form-label-always-active color-highlight font-11">Choose Network</label>
                </div>
                <div class="pb-3"></div>
                <div class="form-custom form-label form-icon">
                    <i class="bi bi-code-square font-14"></i>
                    <input type="number" class="form-control rounded-xs"  name="phone" value="<?php echo e(Auth::user()->phone); ?>" id="c3" placeholder="" />
                    <label for="c3" class="form-label-always-active color-highlight font-11">MPesa Number</label>
                    <span class="font-10">(required)</span>
                </div>
                <div class="pb-3"></div>
                <div class="form-custom form-label form-icon">
                    <i class="bi bi-code-square font-14"></i>
                    <input type="number" readonly class="form-control rounded-xs" id="c4" name="amount" value="150" placeholder="150.00"/>
                    <label for="c4" class="form-label-always-active color-highlight font-11">Amount</label>
                    <span class="font-10">( Currency: KES )</span>
                </div>
                <div class="pb-2"></div>
                <div class="form-check form-check-custom">
                    <input class="form-check-input" type="checkbox" name="type" value="" id="c2">
                    <label class="form-check-label" for="c2">I accept the Transfer <a href="#">Terms of Service</a></label>
                    <i class="is-checked color-green-dark font-14 bi bi-check-circle-fill"></i>
                    <i class="is-unchecked color-green-dark font-14 bi bi-circle"></i>
                </div>
                 
           
            
            </div>
            <button type="submit" data-bs-dismiss="offcanvas" class="mx-3 mb-3 btn btn-sm btn-full gradient-green shadow-bg shadow-bg-s">Pay To Activate Your Account</button>
           </form>
        </div>

       </div>



    </div>

    <script src="public/scripts/bootstrap.min.js"></script>
    <script src="public/scripts/custom.js"></script>
</body>
</html>


<?php /**PATH /home/uniquesq/clarityinvestment.antgpt.africa/resources/views//activate.blade.php ENDPATH**/ ?>