<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Qubits Cube - Team Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Arial', sans-serif;
        }
        .dashboard-header {
            background-color: #4a4e69;
            color: #ffffff;
            padding: 20px 0;
        }
        .dashboard-header h1 {
            font-size: 2rem;
        }
        .stat-card {
            background-color: #fff;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .stat-icon {
            font-size: 2.5rem;
            color: #4a4e69;
        }
    </style>
</head>
<body>
    <?php
    $user = Auth::user();

    // Fetch Level 1: Team 1 - Users invited by the current user
    $team1 = DB::table('users')
        ->where('upline', $user->ref_code)
        ->get()
        ->map(function ($person) {
            // Fetch Level 2: Team 2 - Users invited by this Level 1 person
            $person->team2 = DB::table('users')
                ->where('upline', $person->ref_code)
                ->get();
            return $person;
        });

    // Analytics Calculations
    $level1_investments = $team1->sum('investments');
    $level1_cashouts = $team1->sum('cashouts');
    $level2_investments = $team1->flatMap(fn($person) => $person->team2)->sum('investments');
    $level2_cashouts = $team1->flatMap(fn($person) => $person->team2)->sum('cashouts');
    $level1_count = $team1->count();
    $level2_count = $team1->flatMap(fn($person) => $person->team2)->count();
    ?>

    <header class="dashboard-header text-center">
        <h1>Qubits Cube Team Dashboard</h1>
    </header>

    <div class="container py-5">
        <!-- Analytics Section -->
        <div class="row g-4 mb-5">
            <!-- Total Level 1 Investments -->
            <div class="col-md-4">
                <div class="stat-card text-center p-4">
                    <i class="bi bi-cash-stack stat-icon"></i>
                    <h5>Total Level 1 Investments</h5>
                    <p class="fw-bold text-primary">Ksh <?php echo e(number_format($level1_investments, 2)); ?></p>
                </div>
            </div>
            <!-- Total Level 2 Investments -->
            <div class="col-md-4">
                <div class="stat-card text-center p-4">
                    <i class="bi bi-cash stat-icon"></i>
                    <h5>Total Level 2 Investments</h5>
                    <p class="fw-bold text-success">Ksh <?php echo e(number_format($level2_investments, 2)); ?></p>
                </div>
            </div>
            <!-- Total Level 1 Cashouts -->
            <div class="col-md-4">
                <div class="stat-card text-center p-4">
                    <i class="bi bi-wallet2 stat-icon"></i>
                    <h5>Total Level 1 Cashouts</h5>
                    <p class="fw-bold text-warning">Ksh <?php echo e(number_format($level1_cashouts, 2)); ?></p>
                </div>
            </div>
            <!-- Total Level 2 Cashouts -->
            <div class="col-md-6">
                <div class="stat-card text-center p-4">
                    <i class="bi bi-piggy-bank stat-icon"></i>
                    <h5>Total Level 2 Cashouts</h5>
                    <p class="fw-bold text-danger">Ksh <?php echo e(number_format($level2_cashouts, 2)); ?></p>
                </div>
            </div>
            <!-- Total Members Level 1 -->
            <div class="col-md-6">
                <div class="stat-card text-center p-4">
                    <i class="bi bi-people-fill stat-icon"></i>
                    <h5>Total Members in Level 1</h5>
                    <p class="fw-bold text-info"><?php echo e($level1_count); ?> Members</p>
                </div>
            </div>
            <!-- Total Members Level 2 -->
            <div class="col-md-12">
                <div class="stat-card text-center p-4">
                    <i class="bi bi-people stat-icon"></i>
                    <h5>Total Members in Level 2</h5>
                    <p class="fw-bold text-secondary"><?php echo e($level2_count); ?> Members</p>
                </div>
            </div>
        </div>

        <!-- Team Tables Section -->
        <?php if($team1->isNotEmpty()): ?>
            <!-- Team 1 Table -->
            <div class="mb-5">
                <h2 class="mb-3">Team 1 (Direct Invites)</h2>
                <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-primary">
                        <tr>
                            <th>#</th>
                            <th>Username</th>
                            <th>Phone</th>
                            <th>Cashouts</th>
                            <th>Referral Code</th>
                            <th>Investments (Ksh)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $team1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($person->username); ?></td>
                                <td><?php echo e($person->phone); ?></td>
                                <td>Ksh <?php echo e(number_format($person->cashouts, 2)); ?></td>
                                <td><?php echo e($person->ref_code); ?></td>
                                <td>Ksh <?php echo e(number_format($person->investments, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                </div>
            </div>

            <!-- Team 2 Tables -->
            <div class="mb-5">
                <h2 class="mb-3">Team 2 (Invited by Team 1)</h2>
                <?php $__currentLoopData = $team1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($person->team2->isNotEmpty()): ?>
                        <h4 class="text-secondary">Invited by: <?php echo e($person->username); ?></h4>
                        <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="table-secondary">
                                <tr>
                                    <th>#</th>
                                    <th>Username</th>
                                    <th>Phone</th>
                                    <th>Cashouts</th>
                                    <th>Referral Code</th>
                                    <th>Investments (Ksh)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $person->team2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($member->username); ?></td>
                                        <td><?php echo e($member->phone); ?></td>
                                        <td>Ksh <?php echo e(number_format($member->cashouts, 2)); ?></td>
                                        <td><?php echo e($member->ref_code); ?></td>
                                        <td>Ksh <?php echo e(number_format($member->investments, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <p class="text-center text-muted">You have no team members yet.</p>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home/qubitscube.cfd/public_html/resources/views/partnership.blade.php ENDPATH**/ ?>