<?php $__env->startSection('content'); ?>

    <style>
        /* Add your custom styles here */
        .product-item {
            display: flex;
            margin-bottom: 20px;
            border-radius: 8px;
        }

        .product-image {
            width: 125px;
            height: 150px;
            border-radius: 8px;
            overflow: hidden;
        }

        .product-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .tags {
            color: #ff0000;
            margin-left: 10px;
        }

        .product-details {
            flex: 1;
            padding: 0 10px;
        }

        .product-name {
            display: flex;
            align-items: center;
        }

        .cycles-label {
            margin-left: auto;
            color: #00ff00;
        }

        .product-price {
            color: #00ff00;
            background-color: #3100ff;
            text-decoration: underline;
        }

        .return-rate {
            color: #0000ff;
        }

        .countdown-timer {
            margin-left: auto;
        }

        .income-section {
            display: flex;
            justify-content: space-between;
            margin-top: 10px;
        }

        .day-income,
        .total-income {
            color: #00ff00;
            background-color: #333333;
        }
        
        .card-img-top:hover {
        transform: scale(1.05);
        }
        .overlay:hover {
            background-color: rgba(0, 0, 0, 0.3);
        }
    </style>

    <!-- Main content -->
    <main class="mt-5 pt-2">
        <div class="container">

            <!-- Display Packages -->
            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <h4><?php echo e($errors->first()); ?></h4>
            </div>
            <?php endif; ?>

            <?php if(\Session::has('success')): ?>
            <div class="alert alert-success">
                <h4><?php echo \Session::get('success'); ?></h4>
            </div>
            <?php endif; ?>

            <?php if(\Session::has('error')): ?>
            <div class="alert alert-danger">
                <h4><?php echo \Session::get('error'); ?></h4>
            </div>
            <?php endif; ?>

            <div class="row">
                <?php
                       $packages = DB::table('packages')->get();
                ?>
                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6">
                    <!--<div class="card mb-3">-->
                    <!--    <a href="package?p=<?php echo e($pkg->id); ?>" class="image-full mt-3 rounded-lg text-decoration-none d-block">-->
                    <!--        <img src="<?php echo e(env('APP_RES')); ?>/bgs/product.png" alt="bg" class="card-img-top rounded img-fluid" style="height: 200px;">-->
                    <!--        <div class="card-body">-->
                    <!--            <div class="block space-y-2 text-center">-->
                    <!--                <p class="font-weight-bold">Capital: KES.<?php echo e(number_format($pkg->price)); ?></p>-->
                    <!--                <p class="font-weight-normal">Daily Income: KES.<?php echo e(number_format($pkg->daily_income)); ?></p>-->
                    <!--            </div>-->
                    <!--            <div class="block mb-2 text-center">-->
                    <!--                <p>Upline Bonus: <?php echo e($pkg->upline_bonus); ?></p>-->
                    <!--                <p>Days: <?php echo e($pkg->days); ?></p>-->
                    <!--            </div>-->
                    <!--            <a href="#" class="btn btn-primary w-100">Open Account</a>-->
                    <!--        </div>-->
                    <!--    </a>-->
                    <!--</div>-->
                    
                    <div class="card mb-3 position-relative">
                        <!--package?p=<?php echo e($pkg->id); ?>-->
                        <a href="#" class="image-full mt-3 rounded-lg text-white text-decoration-none d-block">
                            <div class="overlay position-absolute top-0 start-0 w-100 h-100" style="background-color: rgba(0, 0, 0, 0.5);"></div>
                            <img src="<?php echo e(env('APP_RES')); ?>/bgs/product.png" alt="bg" class="card-img-top rounded img-fluid" style="height: 300px;">
                            <div class="position-absolute top-50 start-50 translate-middle text-white text-center">
                                <h5 class="mb-0"><?php echo e($pkg->vip); ?></h5>
                                <p>Capital: KES.<?php echo e(number_format($pkg->price)); ?></p>
                                <p>Daily Income: KES.<?php echo e(number_format($pkg->daily_income)); ?></p>
                                <a href="package?p=<?php echo e($pkg->id); ?>" class="btn btn-primary">Purchase</a>
                            </div>
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Display Investment Data -->
            <div class="row mt-4">
                <div class="col">
                       <!-- Coupon code -->
            <?php
                $datas = DB::table('invest')->where('type', 0)->where('user_id', Auth::user()->id)->get();
            ?>
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Capital</th>
                                <th>Daily</th>
                                <th>Date Invested</th>
                                <th>Days Earned</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($data->capital); ?></td>
                                <td><?php echo e($data->returns); ?></td>
                                <td><?php echo e(date('Y-m-d H:i:s', strtotime($data->date))); ?></td>
                                <td>
                                    <?php if($data->status == 1): ?>
                                    <?php echo e($data->days_paid); ?>

                                    <?php elseif($data->status == 2): ?>
                                    Expired!!
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </main>
    <!-- Main content ends -->

    <!-- Bootstrap JS and Toastr JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <!-- Custom scripts -->
    <script>
        $(document).ready(function() {
            $('#amount_to_invest').on('input', function() {
                var inputValue = $(this).val();
                $('#outputDiv').text('kes:' + ((inputValue * 0.08).toFixed(2)));
            });
        });
    </script>
<?php $__env->stopSection(); ?>























<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uniquesq/schwab.cch-hub.top/resources/views/investment.blade.php ENDPATH**/ ?>