<?php $__env->startSection('content'); ?>
<?php 
    $user = Auth::user();
    $country = strtolower($user->country ?? '');
    
    // Conversion rates
    $conversionRates = [
        'kenya' => ['rate' => 1, 'currency' => 'KES', 'min' => 50],
        'zambia' => ['rate' => 25, 'currency' => 'ZMW', 'min' => 20],
        'tanzania' => ['rate' => 2575, 'currency' => 'TZS', 'min' => 2000],
        'ghana' => ['rate' => 11, 'currency' => 'GHS', 'min' => 10],
        'uganda' => ['rate' => 3560, 'currency' => 'UGX', 'min' => 3000],
        'south sudan' => ['rate' => 4512, 'currency' => 'SSP', 'min' => 4000],
        'rwanda' => ['rate' => 1200, 'currency' => 'RWF', 'min' => 1000]
    ];
    
    $conversion = $conversionRates[$country] ?? ['rate' => 1, 'currency' => 'USD', 'min' => 1];
    $convertedBalance = $user->balance / $conversion['rate'];
?>
<style>
    :root {
        --primary: #4361ee;
        --secondary: #3a0ca3;
        --success: #4cc9f0;
        --danger: #f72585;
        --warning: #f8961e;
        --light: #f8f9fa;
        --dark: #212529;
    }
    
    .withdrawal-container {
        max-width: 500px;
        margin: 0 auto;
        padding: 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }
    
    .withdrawal-header {
        text-align: center;
        margin-bottom: 25px;
    }
    
    .withdrawal-header h4 {
        color: var(--primary);
        font-weight: 700;
    }
    
    .alert-box {
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 20px;
        border-left: 4px solid;
    }
    
    .alert-success {
        background-color: rgba(76, 201, 240, 0.15);
        border-color: var(--success);
        color: #0c5460;
    }
    
    .alert-danger {
        background-color: rgba(247, 37, 133, 0.15);
        border-color: var(--danger);
        color: #721c24;
    }
    
    .form-card {
        border-radius: 10px;
        padding: 20px;
        background: #f8f9fa;
        margin-bottom: 20px;
    }
    
    .form-label {
        font-weight: 600;
        color: var(--dark);
        margin-bottom: 8px;
        display: block;
    }
    
    .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 1px solid #e0e0e0;
        width: 100%;
        transition: all 0.3s;
    }
    
    .form-control:focus {
        border-color: var(--primary);
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    .select-wrapper {
        position: relative;
    }
    
    .select-wrapper:after {
        content: "▼";
        font-size: 12px;
        color: var(--primary);
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        pointer-events: none;
    }
    
    .btn-submit {
        background: var(--primary);
        color: white;
        border: none;
        padding: 12px;
        font-weight: 600;
        border-radius: 8px;
        width: 100%;
        transition: all 0.3s;
    }
    
    .btn-submit:hover {
        background: var(--secondary);
        transform: translateY(-2px);
    }
    
    .btn-submit:disabled {
        background: #cccccc;
        transform: none;
    }
    
    .amount-info {
        background: white;
        border-radius: 8px;
        padding: 15px;
        margin-top: 15px;
        border: 1px solid #e0e0e0;
    }
    
    .amount-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 8px;
    }
    
    .modal-content {
        border-radius: 12px;
        overflow: hidden;
    }
    
    .modal-header {
        background: var(--primary);
        color: white;
    }
    
    .text-muted {
        color: #6c757d;
        font-size: 0.85rem;
    }
    
    .text-primary {
        color: var(--primary);
    }
</style>

<div class="withdrawal-container">
    <div class="withdrawal-header">
        <h4>Withdraw Funds</h4>
        <p class="text-muted">Request withdrawal to your preferred payment method</p>
    </div>

    <?php if(session('success')): ?>
        <div class="alert-box alert-success">
            <i class="bi bi-check-circle-fill me-2"></i> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert-box alert-danger">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <p class="mb-1"><i class="bi bi-exclamation-triangle-fill me-2"></i> <?php echo e($error); ?></p>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <?php if(\Session::has('error')): ?>
        <div class="alert-box alert-danger">
            <i class="bi bi-exclamation-triangle-fill me-2"></i> <?php echo \Session::get('error'); ?>

        </div>
    <?php endif; ?>

    <form method="POST" id="withdrawalForm" action="<?php echo e(route('withdraw')); ?>" onsubmit="disableButton()">
        <?php echo csrf_field(); ?>
        <input type="hidden" id="uniquekey" name="uniquekey">
        <input type="hidden" name="gateway_method" value="<?php echo e($user->gateway_method); ?>">
        <input type="hidden" name="withdraw_account" value="<?php echo e($user->withdraw_account); ?>">
        <input type="hidden" name="phone" value="<?php echo e($user->phone); ?>">

        <div class="form-card">
            <!-- Payment Method -->
            <div class="mb-4">
                <label for="gateway_method" class="form-label">Withdrawal Method</label>
                <div class="select-wrapper">
                    <select name="gateway_method_display" id="gateway_method_display" class="form-control" disabled>
                        <option value="SAFARICOM" selected><?php echo e($user->gateway_method); ?> (<?php echo e($user->withdraw_account); ?>)</option>
                    </select>
                </div>
                <small class="text-muted">Currently only <?php echo e($user->gateway_method); ?> withdrawals available</small>
            </div>

            <!-- Amount Input -->
            <div class="mb-3">
                <label for="amount" class="form-label">Amount (<?php echo e($conversion['currency']); ?>)</label>
                <input 
                    type="number" 
                    name="amount" 
                    class="form-control" 
                    id="amount" 
                    placeholder="Enter amount"
                    required 
                    min="<?php echo e($conversion['min']); ?>"
                    step="1"
                >
                <small class="text-muted">Minimum withdrawal: <?php echo e($conversion['min']); ?> <?php echo e($conversion['currency']); ?></small>
            </div>

            <!-- Amount Breakdown -->
            <div class="amount-info">
              
                <div class="amount-row">
                    <span>≈ <?php echo e($conversion['currency']); ?>:</span>
                    <span  class="text-primary"><?php echo e(number_format($convertedBalance, 2)); ?></span>
                </div>
            </div>
        </div>

        <!-- Submit Button -->
        <button 
            type="submit" 
            class="btn-submit" 
            id="withdrawBtn"
            <?php if(empty($user->withdraw_account)): ?> disabled <?php endif; ?>
        >
            <span id="buttonText">
                <?php if(empty($user->withdraw_account)): ?>
                    Please set withdrawal account
                <?php else: ?>
                    <i class="bi bi-send-fill me-2"></i> Request Withdrawal
                <?php endif; ?>
            </span>
        </button>
    </form>
</div>

<!-- Wallet Address Modal -->
<div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" action="<?php echo e(route('update-wallet-address')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="walletModalLabel">Set Withdrawal Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Gateway Method -->
                    <div class="mb-3">
                        <label for="gateway_method" class="form-label">Payment Method</label>
                        <select name="gateway_method" id="gateway_method" class="form-control" required>
                            <option value="" disabled selected>Select method</option>
                            <option value="SAFARICOM">M-PESA</option>
                            <option value="MTN">MTN</option>
                            <option value="AIRTEL">AIRTEL</option>
                            <option value="BINANCE">BINANCE</option>
                        </select>
                    </div>

                    <!-- Wallet Address -->
                    <div class="mb-3">
                        <label for="withdraw_account" class="form-label">M-PESA Phone Number</label>
                        <input 
                            type="text" 
                            name="withdraw_account" 
                            id="withdraw_account" 
                            class="form-control" 
                            placeholder="e.g. 254712345678" 
                            required
                            pattern="[0-9]{9,12}"
                            title="Please enter a valid phone number"
                        >
                        <small class="text-muted">Enter your M-PESA registered phone number</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Generate random token
        document.getElementById('uniquekey').value = generateRandomToken();
        
        // Show modal if no withdrawal account set
        <?php if(empty($user->withdraw_account)): ?>
            var walletModal = new bootstrap.Modal(document.getElementById('walletModal'));
            walletModal.show();
        <?php endif; ?>
    });

    function disableButton() {
        const btn = document.getElementById('withdrawBtn');
        btn.disabled = true;
        document.getElementById('buttonText').innerHTML = '<i class="bi bi-arrow-repeat me-2"></i> Processing...';
    }

    function generateRandomToken() {
        return Array.from(crypto.getRandomValues(new Uint8Array(32)))
            .map(b => b.toString(16).padStart(2, '0'))
            .join('');
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/cdp24.site/resources/views/user/withdrawal.blade.php ENDPATH**/ ?>