<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="text-center mb-5">
        <h2 class="fw-bold">📘 Daily Quiz Tasks</h2>
        <p class="text-muted">Answer questions based on your active investment packages to earn rewards instantly!</p>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success text-center"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger text-center"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

<form method="POST" action="<?php echo e(route('questions.submit')); ?>">
        <?php echo csrf_field(); ?>

        <?php $__currentLoopData = $questionsByPackage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investmentId => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card shadow mb-5 border-0">
                <div class="card-header bg-primary text-white fw-semibold">
                    Package ID: <?php echo e($data['package_id']); ?> — Capital: ₦<?php echo e(number_format($data['capital'], 2)); ?>

                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $data['questions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-4">
                            <h5 class="mb-3">Q<?php echo e($index + 1); ?>: <?php echo e($question->question_text); ?></h5>

                            
                            <input type="hidden" name="answers[<?php echo e($investmentId); ?><?php echo e($index); ?>][package_id]" value="<?php echo e($data['package_id']); ?>">
                            <input type="hidden" name="answers[<?php echo e($investmentId); ?><?php echo e($index); ?>][capital]" value="<?php echo e($data['capital']); ?>">
                            <input type="hidden" name="answers[<?php echo e($investmentId); ?><?php echo e($index); ?>][question_id]" value="<?php echo e($question->id); ?>">

                            <?php $__currentLoopData = ['option_a', 'option_b', 'option_c', 'option_d']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check mb-2">
                                    <input
                                        class="form-check-input"
                                        type="radio"
                                        name="answers[<?php echo e($investmentId); ?><?php echo e($index); ?>][selected_answer]"
                                        id="q<?php echo e($question->id); ?>_<?php echo e($option); ?>"
                                        value="<?php echo e($option); ?>"
                                        required
                                    >
                                    <label class="form-check-label" for="q<?php echo e($question->id); ?>_<?php echo e($option); ?>">
                                        <?php echo e(strtoupper(str_replace('option_', '', $option))); ?>. <?php echo e($question->$option); ?>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <hr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div class="text-center">
            <button type="submit" class="btn btn-lg btn-success px-5">
                ✅ Submit Answers & Earn
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/cdp24.site/resources/views/daily/questions.blade.php ENDPATH**/ ?>