<?php $__env->startSection('content'); ?>
<div class="container py-5">
    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> <?php echo e(session('success')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Error!</strong> <?php echo e(session('error')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

<script>
    // Check if there is a success or error message in the session
    <?php if(session('success') || session('error')): ?>
        setTimeout(function() {
            // Find the message element and fade it out after 3 seconds
            let message = document.querySelector('.alert');
            if (message) {
                message.style.transition = "opacity 0.5s ease-out";
                message.style.opacity = 0;
                setTimeout(function() {
                    message.style.display = "none";
                }, 500);  // Hide message after fading out
            }
        }, 3000);  // Wait for 3 seconds before hiding
    <?php endif; ?>
</script>


    <?php
        $funds = DB::table('funds')->get(); // Fetch all records from the funds table
    ?>

    <?php $__currentLoopData = $funds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="card shadow-sm mb-4">
            <div class="card-body p-4  position-relative">
                <div class="d-flex align-items-center">
                    <!-- Image Section -->
                    <div class="flex-shrink-0 me-4 text-center">
                        <img src="public/fund<?php echo e($fund->id); ?>.png" 
                             alt="Fund Image"  
                             style="width: 80px; height: 80px;" />
                    </div>
                    
                    <!-- Fund Details Section -->
                    <div class="flex-grow-1">
                        <h5 class="mb-1 text-primary"><strong><?php echo e($fund->vip); ?></strong></h5>
                        <p class="mb-1 text-muted small">Price: <strong> <?php echo e($settings->currency); ?> <?php echo e(number_format($fund->price  * $settings->rate, 2)); ?></strong></p>
                        <p class="mb-1 text-muted small">Daily Income: <strong> <?php echo e($settings->currency); ?> <?php echo e(number_format($fund->daily_income  * $settings->rate, 2)); ?></strong></p>
                        
                        <!-- Badge for Days -->
                        <span class="badge bg-primary position-absolute top-0 end-0 m-2 p-2 rounded-pill">
                            <?php echo e($fund->days); ?> Days
                        </span>
                    </div>
                </div>
                
                <!-- Action Button -->
                <div class="text-start mt-3">
                    <form action="<?php echo e(route('wealthfund.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="fund_id" value="<?php echo e($fund->id); ?>">
                        <button type="submit" class="btn btn-sm outline-button rounded-pill px-4 mt-2">
                            Invest Now
                        </button>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<style>
    .outline-button {
    display: inline-block;
    padding: 5px 10px;
    font-size: 16px;
    font-weight: bold;
    color: #007bff; /* Text color */
    background-color: transparent; /* Transparent background */
    border: 2px solid #007bff; /* Solid border */
    border-radius: 5px; /* Rounded edges */
    cursor: pointer; /* Pointer cursor on hover */
    transition: all 0.3s ease; /* Smooth transition */
}

.outline-button:hover {
    background-color: #007bff; /* Background changes on hover */
    color: #fff; /* Text color changes on hover */
    border-color: #0056b3; /* Darker border on hover */
}

</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sahuapp.work/public_html/resources/views/user/wealthfund.blade.php ENDPATH**/ ?>