<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="generator" content="">
    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- bootstrap icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <!-- style css for this template -->
    <link href="public/assets/css/style.css" rel="stylesheet" id="style">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />

    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
       <!--tailwind css 3-->
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="body-scroll" data-page="addmoney">
<?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
     <!-- Begin page -->
    <main class="h-screen mt-10 pt-10">

        <!-- Header -->
        <header class="fixed top-0 left-0 right-0 text-white  p-4 z-10">
            <div class="flex items-center justify-between">
                <div class="">
                    <a href="home">
                        <button type="button" class="bg-gray-100 shadow rounded-lg text-gray-700 px-2 font-bold">
                            <i class="bi bi-arrow-left"></i>
                        </button>
                    </a>
                </div>

            </div>
        </header>
          <!-- Main Content -->
        
         <!--Header ends -->
            <!-- select Amount -->
            <?php if(session('error')): ?>
                <div class="alert alert-danger" >
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <div>
            <p class="text-center mt-20 uppercase"><b>Create a withdrawal</b></p>
            
            <div class="text-gray-900 container">
                <div class="col-12 text-center mb-4 mt-2">
                    <form method="post" id="withdrawalForm" class="w-full p-4" action="<?php echo e(route('withdraw')); ?>">
                        <?php echo csrf_field(); ?>
                        <input id="uniquekey" type="hidden" name="uniquekey">
                        <input type="text"  name="phone" value="<?php echo e(Auth::user()->phone); ?>" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                            placeholder="Enter Mpesa Number">
                        <br>
                        <input type="number" min="60" name="amount" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Enter Amount">
                        <br>

                        <button type="submit" id="submitButton" class="bg-blue-700 text-white shadow-sm w-100 py-1 px-4 rounded-md">
                            Initiate Withdrawal
                        </button>
                    </form>
                </div>
            </div>
            </div>
            
            

     
            <div class="card m-4 ">
                <div class="card-body">
                      <div class="grid grid-cols-1 md:grid-cols-3 items-center font-medium mb-3">
                        <div class="col-span-12">
                            <div class="border-dashed border-t mb-3"></div>
                        </div>
                        <div>
                            <p>Transfer Amount</p>
                        </div>
                        <div class="text-end">
                            <p class="text-muted" id="transaction">0.00</p>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-3 items-center font-medium mb-3">
                        <div class="col-span-12">
                            <div class="border-dashed border-t mb-3"></div>
                        </div>
                        <div>
                            <p>Transaction Charge (10%)</p>
                        </div>
                        <div class="text-end">
                            <p class="text-muted" id="transaction-cost">0.00</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-3 items-center font-medium mb-3">
                        <div class="col-span-12">
                            <div class="border-dashed border-t mb-3"></div>
                        </div>
                        <div>
                            <p>Amount To Receive</p>
                        </div>
                        <div class="text-end">
                            <p class="text-muted" id="total-deduction">0.00</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- coupon code-->
            <?php
            $datas =   DB::table('cashouts')->where('phone', Auth::user()->phone)->get();
         ?>
            <div class="bg-white rounded-md shadow-md m-2">
                <div class="col-12 text-center mb-4 mt-2">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead class="">
                                <tr>
                                    <th>Amount</th>
                                    <th>Phone</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                <tr class="table-responsive">
                                    <td> <?php echo e($data->amount); ?> </td>
                                    <td> <?php echo e($data->phone); ?> </td>
                                    <td> <?php echo e($data->status); ?> </td>
                                    <td><?php echo e($data ->created_at); ?></td>

                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
        <!-- main page content ends -->


    </main>
    <!-- Page ends-->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
    // Generate a random token
    var token = generateRandomToken();

        // Set the token value to the hidden input field
        document.getElementById('uniquekey').value = token;
    });
    
    // Function to generate a random token
    function generateRandomToken() {
        // Define the characters allowed in the token
        var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    
        // Define the length of the token
        var length = 32; // Adjust the length of the token as needed
    
        // Initialize an empty string to store the token
        var token = '';
    
        // Generate a random token by appending random characters from the 'chars' string
        for (var i = 0; i < length; i++) {
            token += chars.charAt(Math.floor(Math.random() * chars.length));
        }
    
        return token;
    }

    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var form = document.getElementById('withdrawalForm');
            var submitButton = document.getElementById('submitButton');
             var formSubmitted = false;
            
            form.addEventListener('submit', function(event) {
                // Prevent multiple form submissions
                submitButton.disabled = true;
                 // Prevent multiple form submissions
                if (formSubmitted) {
                    event.preventDefault(); 
                    // Prevent the default form submission
                    return false;
                }
                // Set the flag to true to indicate form submission
        
                formSubmitted = true; 
            });
            
           
    });

    </script>

   <script>
               // Get the amount input field
        var amountInput = document.querySelector('input[name="amount"]');
        
        // Listen for changes in the amount input
        amountInput.addEventListener('input', function() {
            // Get the entered amount
            var amount = parseFloat(amountInput.value);
        
            // Calculate the transaction cost (5% of the amount)
            var transactionCost = amount * 0.1;
            
              // Update the display of the transaction cost
            var transactionElement = document.getElementById('transaction');
            transactionElement.textContent = amount.toFixed(2);
        
            // Update the display of the transaction cost
            var transactionCostElement = document.getElementById('transaction-cost');
            transactionCostElement.textContent = transactionCost.toFixed(2);
        
            // Update the total deduction
            var totalDeductionElement = document.getElementById('total-deduction');
            var totalDeduction = amount - transactionCost;
            totalDeductionElement.textContent = totalDeduction.toFixed(2);
        });

   </script>


</body>

</html><?php /**PATH /home/nakamoto/Desktop/webs/etica/resources/views/user/withdrawal.blade.php ENDPATH**/ ?>