<?php $__env->startSection('content'); ?>

<?php

            $user = Auth::user();
            $countryCode = $user->country_code ?? '';

            if ($countryCode == '254') { // Kenya
                $conversionRate = 130; // 1 USDT = 130 KES
                $currency = 'KES';
            } elseif ($countryCode == '260') { // Zambia
                $conversionRate = 30; // 1 USDT = 30 ZMW
                $currency = 'ZMW';
            } elseif ($countryCode == '233') { // GHS
                $conversionRate = 15; // 1 GHS = 15 GHS
                $currency = 'GHS';
            } elseif ($countryCode == '256') { // GHS
                $conversionRate = 3675; // 1 GHS = 15 GHS
                $currency = 'UGX';
            }  elseif ($countryCode == '211') { // South sudan
                $conversionRate = 4450; // 1 USDT = 30 SSP
                $currency = 'SSP';
            } else { // Default to USD for other countries
                $conversionRate = 1;
                $currency = 'USD';
            }

            $convertedBalance = $user->balance / $conversionRate;
            $min = 1 * $conversionRate;



            $packages = DB::table('packages')->get();
            $img = $packages->get('images');

?>

<?php

// Fetch and count Level 1 downlines (direct referrals)
$firstLevelDownlines = DB::table('users')
    ->where('upline', Auth::user()->ref_code)
    ->get();
$firstLevelCount = $firstLevelDownlines->count();

// Collect IDs and referral codes of Level 1 downlines
$firstLevelIds = $firstLevelDownlines->pluck('id');
$firstLevelRefCodes = $firstLevelDownlines->pluck('ref_code');

// Initialize arrays for counts and bonuses
$secondLevelCounts = [];
$thirdLevelCounts = [];
$levelBonuses = [];

// Process Level 1 downlines
$secondLevelDownlines = DB::table('users')
    ->whereIn('upline', $firstLevelRefCodes)
    ->get();
$secondLevelCount = $secondLevelDownlines->count();

$secondLevelIds = $secondLevelDownlines->pluck('id');
$secondLevelRefCodes = $secondLevelDownlines->pluck('ref_code');

// Process Level 2 downlines
$thirdLevelDownlines = DB::table('users')
    ->whereIn('upline', $secondLevelRefCodes)
    ->get();
$thirdLevelCount = $thirdLevelDownlines->count();

$thirdLevelIds = $thirdLevelDownlines->pluck('id');

// Calculate bonuses for Level 2 and Level 3
// Fetch total investments per level
$level1Investment = DB::table('invest')->whereIn('user_id', $firstLevelIds)->sum('capital');
$level2Investment = DB::table('invest')->whereIn('user_id', $secondLevelIds)->sum('capital');
$level3Investment = DB::table('invest')->whereIn('user_id', $thirdLevelIds)->sum('capital');

// Apply bonus percentages
$bonusLevel1 = $level1Investment * 0.12; // 12%
$bonusLevel2 = $level2Investment * 0.02; // 2%
$bonusLevel3 = $level3Investment * 0.01; // 1%

// Total commission from all levels
$totalCommission = $bonusLevel1 + $bonusLevel2 + $bonusLevel3;



$countDownline =$firstLevelCount + $secondLevelCount + $thirdLevelCount;

// Fetch investments for Level 1
$totalInvestLevel1 = DB::table('invest')
    ->whereIn('user_id', $firstLevelIds)
    ->sum('capital');

// Fetch investments for Level 2
$totalInvestLevel2 = DB::table('invest')
    ->whereIn('user_id', $secondLevelIds)
    ->sum('capital');

// Fetch investments for Level 3
$totalInvestLevel3 = DB::table('invest')
    ->whereIn('user_id', $thirdLevelIds)
    ->sum('capital');

// Fetch withdrawals for Level 1
$totalWithdrawalsLevel1 = DB::table('cashouts')
    ->whereIn('phone', $firstLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 2
$totalWithdrawalsLevel2 = DB::table('cashouts')
    ->whereIn('phone', $secondLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 3
$totalWithdrawalsLevel3 = DB::table('cashouts')
    ->whereIn('phone', $thirdLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

?>

<div class="container text-center mt-4">
    <h4 class="text-white mb-4">Team data</h4>

    <div class="row g-3 text-white">
        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5><?php echo e($countDownline); ?></h5>
                <p>Total Team</p>
            </div>
        </div>
        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5>KES.<?php echo e($totalCommission); ?></h5>
                <p> Commission</p>
            </div>
        </div>

        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5><?php echo e($firstLevelCount); ?></h5>
                <p>Level 1 Team</p>
            </div>
        </div>
        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5>KES.<?php echo e($bonusLevel1); ?></h5>
                <p> Commission</p>
            </div>
        </div>

        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5><?php echo e($secondLevelCount); ?></h5>
                <p>Level 2 Team</p>
            </div>
        </div>
        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5>KES.<?php echo e($bonusLevel2); ?></h5>
                <p> Commission</p>
            </div>
        </div>

        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5><?php echo e($thirdLevelCount); ?></h5>
                <p>Level 3 Team</p>
            </div>
        </div>
        <div class="col-6">
            <div class="bg-dark p-3 rounded"> 
                <h5>KES.<?php echo e($bonusLevel3); ?></h5>
                <p> Commission</p>
            </div>
        </div>
    </div>

    <div class="mt-4">
        <a href="<?php echo e(route('downlines')); ?>" class="btn btn-primary w-100" style="background: linear-gradient(to right, #00c6ff, #0072ff); border: none;">
            Invite friends
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/asheq.top/resources/views/team/team.blade.php ENDPATH**/ ?>