<?php $__env->startSection('content'); ?>



<?php

// Fetch and count Level 1 downlines (direct referrals)
$firstLevelDownlines = DB::table('users')
    ->where('upline', Auth::user()->ref_code)
    ->get();
$firstLevelCount = $firstLevelDownlines->count();

// Collect IDs and referral codes of Level 1 downlines
$firstLevelIds = $firstLevelDownlines->pluck('id');
$firstLevelRefCodes = $firstLevelDownlines->pluck('ref_code');

// Initialize arrays for counts and bonuses
$secondLevelCounts = [];
$thirdLevelCounts = [];
$levelBonuses = [];

// Process Level 1 downlines
$secondLevelDownlines = DB::table('users')
    ->whereIn('upline', $firstLevelRefCodes)
    ->get();
$secondLevelCount = $secondLevelDownlines->count();

$secondLevelIds = $secondLevelDownlines->pluck('id');
$secondLevelRefCodes = $secondLevelDownlines->pluck('ref_code');

// Process Level 2 downlines
$thirdLevelDownlines = DB::table('users')
    ->whereIn('upline', $secondLevelRefCodes)
    ->get();
$thirdLevelCount = $thirdLevelDownlines->count();

$thirdLevelIds = $thirdLevelDownlines->pluck('id');

// Calculate bonuses for Level 2 and Level 3
$totalBonusLevel2 = DB::table('invest')
    ->whereIn('user_id', $secondLevelIds)
    ->sum('upline_bonus');

$totalBonusLevel3 = DB::table('invest')
    ->whereIn('user_id', $thirdLevelIds)
    ->sum('upline_bonus');

// Fetch total upline bonuses for Level 1
$totalUplineBonus = DB::table('invest')
    ->whereIn('user_id', $firstLevelIds)
    ->sum('upline_bonus');

$countDownline =$firstLevelCount + $secondLevelCount + $thirdLevelCount;
$totaDownlinesBonuses = $totalUplineBonus + $totalBonusLevel2 + $totalBonusLevel3;

// Fetch investments for Level 1
$totalInvestLevel1 = DB::table('invest')
    ->whereIn('user_id', $firstLevelIds)
    ->sum('capital');

// Fetch investments for Level 2
$totalInvestLevel2 = DB::table('invest')
    ->whereIn('user_id', $secondLevelIds)
    ->sum('capital');

// Fetch investments for Level 3
$totalInvestLevel3 = DB::table('invest')
    ->whereIn('user_id', $thirdLevelIds)
    ->sum('capital');

// Fetch withdrawals for Level 1
$totalWithdrawalsLevel1 = DB::table('cashouts')
    ->whereIn('phone', $firstLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 2
$totalWithdrawalsLevel2 = DB::table('cashouts')
    ->whereIn('phone', $secondLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

// Fetch withdrawals for Level 3
$totalWithdrawalsLevel3 = DB::table('cashouts')
    ->whereIn('phone', $thirdLevelIds)
    ->sum('amount'); // Adjust 'amount' if the column name is different

?>
<main class="h-100 p-3 text-white" style="background-color: #000;">
    <style>
        .invite-header {
            font-size: 2rem;
            font-weight: bold;
            color: #00aaff;
        }

        .invite-card {
            background: #0a0a23;
            border-radius: 12px;
            padding: 20px;
            margin-top: 20px;
            text-align: center;
        }

        .invite-code {
            background: #111;
            border: 1px solid #333;
            padding: 10px 15px;
            border-radius: 10px;
            font-size: 1.2rem;
            font-weight: bold;
            color: #0af;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .invite-code i {
            margin-left: 10px;
            cursor: pointer;
            color: #0af;
        }

        .btn-invite {
            background: linear-gradient(to right, #0af, #00f0ff);
            border: none;
            color: #fff;
            border-radius: 8px;
            padding: 10px 30px;
            font-weight: bold;
        }

        .btn-assist {
            background: linear-gradient(to right, #0af, #0055ff);
            border: none;
            color: #fff;
            border-radius: 8px;
            padding: 10px 30px;
            font-weight: bold;
        }
    </style>

    <div class="text-center mt-4">
        <div class="invite-header">Invite friends</div>
    </div>

    <div class="text-center mt-3">
        <img src="<?php echo e(asset('public/assets/img/user-removebg-preview.png')); ?>" alt="Invite Banner" class="img-fluid" style="max-height: 100px;">
    </div>

    <div class="invite-card mt-4">
        <h6 class="text-active" style="color:#FFFFFF;">My invitation code</h6>
        <div class="invite-code mt-2">
            <?php echo e(Auth::user()->ref_code ?? 'ep190798jy'); ?>

            <i class="bi bi-clipboard" onclick="copyInviteCode('<?php echo e(env('APP_URL')); ?>/register?invite=<?php echo e(Auth::user()->ref_code); ?>')"></i>
        </div>

        <div class="mt-4 d-flex justify-content-center gap-3">
            <button class="btn btn-invite">Invite</button>
            <button class="btn btn-assist">Assist</button>
        </div>
    </div>

    <h5 class="mb-3">My Downlines</h5>

    <!-- Buttons to toggle levels -->
    <div class="mb-3">
        <button class="btn btn-primary btn-sm me-2" onclick="toggleTable('level1')">Level 1</button>
        <button class="btn btn-success btn-sm me-2" onclick="toggleTable('level2')">Level 2</button>
        <button class="btn btn-warning btn-sm" onclick="toggleTable('level3')">Level 3</button>
    </div>

    <!-- Level 1 Table -->
    <div id="level1" class="downline-table" style="display: none;">
        <h6>Level 1 Downlines</h6>
        <table class="table table-bordered table-sm">
            <thead>
                <tr>
                    <th>User ID</th>
                    <th>Phone</th>
                    <th>Username</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $firstLevelDownlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($user->id); ?></td>
                        <td><?php echo e($user->phone); ?></td>
                        <td><?php echo e($user->username); ?></td>
                        <td><?php echo e($user->status ? 'Active' : 'Inactive'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="4" class="text-center">No downlines at Level 1.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Level 2 Table -->
    <div id="level2" class="downline-table" style="display: none;">
        <h6>Level 2 Downlines</h6>
        <table class="table table-bordered table-sm">
            <thead>
                <tr>
                    <th>User ID</th>
                    <th>Phone</th>
                    <th>Username</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $secondLevelDownlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($user->id); ?></td>
                        <td><?php echo e($user->phone); ?></td>
                        <td><?php echo e($user->username); ?></td>
                        <td><?php echo e($user->status ? 'Active' : 'Inactive'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="4" class="text-center">No downlines at Level 2.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Level 3 Table -->
    <div id="level3" class="downline-table" style="display: none;">
        <h6>Level 3 Downlines</h6>
        <table class="table table-bordered table-sm">
            <thead>
                <tr>
                    <th>User ID</th>
                    <th>Phone</th>
                    <th>Username</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $thirdLevelDownlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($user->id); ?></td>
                        <td><?php echo e($user->phone); ?></td>
                        <td><?php echo e($user->username); ?></td>
                        <td><?php echo e($user->status ? 'Active' : 'Inactive'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="4" class="text-center">No downlines at Level 3.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>


<script>
    function toggleTable(levelId) {
        document.querySelectorAll('.downline-table').forEach(table => {
            table.style.display = 'none';
        });
        document.getElementById(levelId).style.display = 'block';
    }
</script>

    <script>
        function copyInviteCode(code) {
            navigator.clipboard.writeText(code);
            alert('Code copied: ' + code);
        }
    </script>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/p-h.site/resources/views/user/downlines.blade.php ENDPATH**/ ?>