<?php $__env->startSection('content'); ?>
<?php
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

$userId = Auth::id();

$deposits = DB::table('deposits')
    ->where('username', $userId)
    ->orderByDesc('created_at')
    ->get();

$cashouts = DB::table('cashouts')
    ->where('phone', $userId)
    ->orderByDesc('created_at')
    ->get();

$invests = DB::table('invest')
    ->where('user_id', $userId)
    ->orderByDesc('created_at')
    ->get();

?>
<?php
$user = Auth::user();
$country = strtolower(trim($user->country));

// Base currency: KES
$currency = 'KES';
$exchange = 1;
$payTo = '3725674';
$method = 'M-PESA BUY GOODS';
$to = 'BRIAN KIARIE';

// Convert from KES → Local Currency
switch ($country) {
    case 'tanzania':
        $currency = 'TZS';
        $exchange = 20; // 1 KES = 20 TZS
        $payTo = '+255612345678';
        $method = 'Tigo Pesa Tanzania';
        $to = 'TOGO';
        break;

    case 'uganda':
        $currency = 'UGX';
        $exchange = 32; // 1 KES = 32 UGX
        $payTo = '+256772345678';
        $method = 'MTN Uganda';
        $to = '';
        break;

    case 'rwanda':
        $currency = 'RWF';
        $exchange = 9.8;
        $payTo = '+250782334455';
        $method = 'MTN Rwanda';
        $to = 'MTN';
        break;

    case 'botswana':
        $currency = 'BWP';
        $exchange = 0.13;
        $payTo = '+26771234567';
        $method = 'Orange Money Botswana';
        $to = 'ORANGE';
        break;

    case 'south sudan':
        $currency = 'SSP';
        $exchange = 10;
        $payTo = '809856';
        $method = 'Agent ID';
        $to = 'Agent';
        break;

    case 'cameroon':
        $currency = 'XAF';
        $exchange = 4.8;
        $payTo = '+237612345678';
        $method = 'MTN Cameroon';
        $to = 'MTN';
        break;

    case 'west africa':
    case 'cote d’ivoire':
    case 'ivory coast':
        $currency = 'XOF';
        $exchange = 4.7;
        $payTo = '+2250123456789';
        $method = 'Orange Money West Africa';
        $to = 'Orange';
        break;

    case 'ghana':
        $currency = 'GHS';
        $exchange = 0.089;
        $payTo = '+233501234567';
        $method = 'MTN Ghana';
        $to = 'MTN';
        break;

    case 'malawi':
        $currency = 'MWK';
        $exchange = 12.5;
        $payTo = '+265991234567';
        $method = 'Airtel Money Malawi';
        $to = 'Airtel';
        break;

    case 'zambia':
        $currency = 'ZMW';
        $exchange = 0.19;
        $payTo = '+260971234567';
        $method = 'MTN Zambia';
        $to = 'MTN';
        break;

    case 'nigeria':
        $currency = 'NGN';
        $exchange = 5.6;
        $payTo = '+2347012345678';
        $method = 'Bank Transfer Nigeria';
        $to = 'Bank';
        break;

    case 'usa':
    case 'united states':
        $currency = 'USD';
        $exchange = 0.00769; // 1 KES = 0.00769 USD
        $payTo = 'TViTtvuJo2DkABCexampleWallet9876';
        $method = 'USDT (TRC20)';
        $to = 'Binance';
        break;

    // Fallback for unsupported or missing countries
    default:
        $currency = 'KES';
        $exchange = 1;
        $payTo = '3725674';
        $method = 'M-PESA BUY GOODS';
        $to = 'BRIAN KIARIE';
        break;
}

$convertedAmount = number_format(5 * $exchange, 2); // 5 KES converted
?>

<style>
    .order-table th, .order-table td {
    vertical-align: middle;
    font-size: 15px;
}

.order-table tbody tr:hover {
    background: #f0fff0;
}

.badge {
    padding: 5px 10px;
    border-radius: 10px;
    font-size: 12px;
}

</style>
<div class="container my-4">
    <h4 class="text-center mb-4"> My Orders</h4>

    <?php if($invests->isEmpty()): ?>
        <div class="alert alert-info text-center">
            You have no active orders.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped order-table">
                <thead class="table-success text-center">
                    <tr>
                        <th>ID</th>
                        <th>Capital</th>
                        <th>Returns</th>
                        <th>Status</th>
                        <th>Next Pay</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="text-center">
                            <td><?php echo e($inv->id); ?></td>
                            <td><?php echo e($currency); ?> <?php echo e(number_format($inv->capital * $exchange, 2)); ?></td>
                            <td><?php echo e($currency); ?> <?php echo e(number_format($inv->returns * $exchange, 2)); ?></td>
                            <td>
                                <?php if($inv->status == '1'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Completed</span>
                               
                                <?php endif; ?>
                            </td>
                            <td>
                                <span 
                                    class="countdown" 
                                    data-next="<?php echo e(\Carbon\Carbon::parse($inv->next_payment)->timestamp); ?>"
                                    data-end="<?php echo e(\Carbon\Carbon::parse($inv->created_at)->addDays($inv->period)->timestamp); ?>"
                                ></span>
                            </td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>
<script>
    function updateCountdowns() {
        const countdownEls = document.querySelectorAll('.countdown');
        const now = Math.floor(Date.now() / 1000);

        countdownEls.forEach(el => {
            const nextTime = parseInt(el.getAttribute('data-next'));
            const endTime = parseInt(el.getAttribute('data-end'));

            if (now >= endTime) {
                el.innerHTML = `<span class="text-muted">Completed</span>`;
                return;
            }

            let diff = nextTime - now;

            if (diff <= 0) {
                // Reset for next 24 hours
                const newNext = nextTime + 86400; // 24 hrs in seconds
                el.setAttribute('data-next', newNext);
                diff = newNext - now;
            }

            const hours = Math.floor(diff / 3600);
            const minutes = Math.floor((diff % 3600) / 60);
            const seconds = diff % 60;

            el.innerHTML = `${hours}h ${minutes}m ${seconds}s`;
        });
    }

    setInterval(updateCountdowns, 1000);
    updateCountdowns();
</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/nxts.site/resources/views/user/orders.blade.php ENDPATH**/ ?>