<?php $__env->startSection('content'); ?>
<?php 
    $user = Auth::user();
    $countryCode = $user->country ?? '';
    
    // Conversion rates
    $conversionRates = [
        'Kenya' => ['rate' => 130, 'currency' => 'KES'],
        'Zambia' => ['rate' => 25, 'currency' => 'ZMW'],
        'Tanzania' => ['rate' => 2575, 'currency' => 'TZS'],
        'Ghana' => ['rate' => 11, 'currency' => 'GHS'],
        'Uganda' => ['rate' => 3560, 'currency' => 'UGX'],
        'South Sudan' => ['rate' => 4512, 'currency' => 'SSP']
    ];
    
    $conversion = $conversionRates[$countryCode] ?? ['rate' => 1, 'currency' => 'USD'];
    $convertedBalance = $user->balance / $conversion['rate'];
    $min = 1 * $conversion['rate'];
?>
<style>
    /* Modern Color Scheme */
    :root {
        --primary: #4361ee;
        --secondary: #3f37c9;
        --success: #4cc9f0;
        --light: #f8f9fa;
        --dark: #212529;
        --warning: #f8961e;
        --danger: #f72585;
    }
    
    .deposit-container {
        max-width: 600px;
        margin: 0 auto;
        padding: 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }
    
    .deposit-header {
        text-align: center;
        margin-bottom: 30px;
    }
    
    .deposit-header h4 {
        color: var(--primary);
        font-weight: 700;
        margin-bottom: 5px;
    }
    
    .deposit-header p {
        color: #6c757d;
        font-size: 0.9rem;
    }
    
    .payment-method-card {
        border: none;
        background: linear-gradient(to left, purple 0%,  #000 100%);
        
        color:#fff;
        border-radius: 10px;
        overflow: hidden;
        margin-bottom: 25px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .payment-method-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }
    
    .card-header {
        background: var(--primary);
        color: white;
        padding: 15px 20px;
        font-weight: 600;
        border-bottom: none;
    }
    
    .card-body {
        padding: 25px;
    }
    
    .instruction-list {
        padding-left: 20px;
    }
    
    .instruction-list li {
        margin-bottom: 10px;
        color: var(--dark);
    }
    
    .instruction-list strong {
        color: var(--primary);
    }
    
    .copy-btn {
        background: var(--primary);
        color: white;
        border: none;
        border-radius: 5px;
        padding: 2px 8px;
        font-size: 0.8rem;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .copy-btn:hover {
        background: var(--secondary);
    }
    
    .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 1px solid #e0e0e0;
    }
    
    .form-control:focus {
        border-color: var(--primary);
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    .btn-submit {
        background: var(--primary);
        border: none;
        padding: 12px;
        font-weight: 600;
        border-radius: 8px;
        width: 100%;
        transition: all 0.3s;
    }
    
    .btn-submit:hover {
        background: var(--secondary);
        transform: translateY(-2px);
    }
    
    .divider {
        display: flex;
        align-items: center;
        margin: 25px 0;
    }
    
    .divider::before, .divider::after {
        content: "";
        flex: 1;
        border-bottom: 1px solid #e0e0e0;
    }
    
    .divider-text {
        padding: 0 15px;
        color: #6c757d;
        font-size: 0.9rem;
    }
    
    .alert {
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 20px;
    }
    
    .alert-success {
        background-color: rgba(76, 201, 240, 0.15);
        border-left: 4px solid var(--success);
        color: #0c5460;
    }
    
    .alert-danger {
        background-color: rgba(247, 37, 133, 0.15);
        border-left: 4px solid var(--danger);
        color: #721c24;
    }
    
    .wallet-address-container {
        display: flex;
        gap: 10px;
        margin-bottom: 20px;
    }
    
    .wallet-address {
        flex: 1;
        background: #f8f9fa;
        padding: 12px;
        border-radius: 8px;
        font-family: monospace;
        border: 1px dashed #adb5bd;
    }
    
    .highlight-text {
        color: var(--primary);
        font-weight: 600;
    }
    
    .recipient-info {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
    }
</style>

<div class="deposit-container">
    <div class="deposit-header">
        <h4>Fund Your Account</h4>
        <p>Select your preferred deposit method below</p>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <i class="bi bi-check-circle-fill me-2"></i> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <p><i class="bi bi-exclamation-triangle-fill me-2"></i> <?php echo e($error); ?></p>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <?php if(strtolower($user->country) == 'kenya'): ?>
        <div class="payment-method-card">
            <div class="card-header">
                <i class="bi bi-phone me-2"></i> M-PESA Deposit
            </div>
            <div class="card-body">
                <form method="post" action="<?php echo e(route('depositing')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label class="form-label">Phone Number</label>
                        <input type="number" class="form-control" name="phone" value="<?php echo e($user->phone); ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Amount (KES)</label>
                        <input type="number" class="form-control" placeholder="Enter Amount" name="amount" min="1" required>
                       
                    </div>
                    
                    <button type="submit" class="btn btn-submit mt-3">
                        <i class="bi bi-send-fill me-2"></i> Initiate Payment
                    </button>
                </form>
            </div>
        </div>
        
    <?php elseif(in_array(strtolower($user->country), ['south sudan', 'tanzania', 'uganda', 'zambia', 'rwanda'])): ?>
        <?php
            $countryData = [
                'south sudan' => [
                    'title' => 'MTN Mobile Money (South Sudan)',
                    'steps' => [
                        'Dial *200# on your phone',
                        'Select <strong>International Transfer</strong>',
                        'Choose <strong>Kenya / M-PESA</strong>',
                        'Enter recipient number: <span class="highlight-text">+254757586765</span> <button onclick="copyToClipboard(\'+254757586765\')" class="copy-btn"><i class="bi bi-clipboard"></i></button>',
                        'Confirm and send payment'
                    ],
                    'recipient' => 'MWENDE KITHUKU'
                ],
                'tanzania' => [
                    'title' => 'Tigo Pesa (Tanzania) → M-PESA (Kenya)',
                    'steps' => [
                        'Dial *150*01# on your phone',
                        'Choose <strong>Send Money</strong>',
                        'Select <strong>International Transfer</strong>',
                        'Choose <strong>Kenya - M-PESA</strong>',
                        'Enter recipient number: <span class="highlight-text">+254798660204</span> <button onclick="copyToClipboard(\'+254798660204\')" class="copy-btn"><i class="bi bi-clipboard"></i></button>',
                        'Enter the amount to send (TZS)',
                        'Confirm the recipient name: <span class="highlight-text">Beatrice Makena</span>'
                    ],
                    'recipient' => 'Beatrice Makena'
                ],
                'uganda' => [
                    'title' => 'MTN Mobile Money (Uganda) → M-PESA (Kenya)',
                    'steps' => [
                        'Dial *165# on your phone',
                        'Select <strong>6. Send Money</strong>',
                        'Choose <strong>1. East Africa</strong>',
                        'Select <strong>Kenya</strong>',
                        'Enter recipient number: <span class="highlight-text">+254798660204</span> <button onclick="copyToClipboard(\'+254798660204\')" class="copy-btn"><i class="bi bi-clipboard"></i></button>',
                        'Enter amount to send (UGX)',
                        'Confirm recipient name: <span class="highlight-text">Beatrice Makena</span>'
                    ],
                    'recipient' => 'Beatrice Makena'
                ],
                'zambia' => [
                    'title' => 'MTN MoMo (Zambia) → Airtel Money (Kenya)',
                    'steps' => [
                        'Dial *115# on your MTN Zambia line',
                        'Select <strong>International Transfer</strong>',
                        'Choose <strong>Kenya</strong>',
                        'Enter recipient number: <span class="highlight-text">+254105509925</span> <button onclick="copyToClipboard(\'+254105509925\')" class="copy-btn"><i class="bi bi-clipboard"></i></button>',
                        'Enter amount in ZMW',
                        'Confirm recipient name: <span class="highlight-text">Mark Maiyo</span>'
                    ],
                    'recipient' => 'Mark Maiyo'
                ],
                'rwanda' => [
                    'title' => 'MTN Mobile Money (Rwanda) → M-PESA (Kenya)',
                    'steps' => [
                        'Dial *182# on your phone',
                        'Select <strong>Send Money</strong>',
                        'Choose <strong>International Transfer</strong>',
                        'Select <strong>Kenya</strong>',
                        'Enter recipient number: <span class="highlight-text">+254798660204</span> <button onclick="copyToClipboard(\'+254798660204\')" class="copy-btn"><i class="bi bi-clipboard"></i></button>',
                        'Enter amount in RWF',
                        'Confirm recipient name: <span class="highlight-text">Beatrice Makena</span>'
                    ],
                    'recipient' => 'Beatrice Makena'
                ]
            ];
            
            $currentCountry = strtolower($user->country);
            $data = $countryData[$currentCountry];
        ?>
        
        <div class="payment-method-card">
            <div class="card-header">
                <i class="bi bi-wallet2 me-2"></i> <?php echo e($data['title']); ?>

            </div>
            <div class="card-body">
                <h5 class="mb-3">Payment Instructions</h5>
                <ol class="instruction-list">
                    <?php $__currentLoopData = $data['steps']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo $step; ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ol>
                
                <div class="recipient-info">
                    <p class="mb-1"><strong>Recipient Name:</strong> <?php echo e($data['recipient']); ?></p>
                    <p class="mb-0"><strong>Currency:</strong> <?php echo e($conversion['currency']); ?></p>
                </div>
                
                <div class="divider">
                    <span class="divider-text">Confirm Payment</span>
                </div>
                
                <form action="<?php echo e(route('deposit')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="email" value="<?php echo e($user->email); ?>">
                    <input type="hidden" name="phone" value="<?php echo e($user->phone); ?>">
                    <input type="hidden" name="username" value="<?php echo e($user->username); ?>">
                    <input type="hidden" name="country" value="<?php echo e($user->country); ?>">
                    
                    <div class="mb-3">
                        <label class="form-label">Upload Proof of Payment</label>
                        <input type="file" name="images" class="form-control" required>
                        <small class="text-muted">Upload screenshot or receipt of your payment</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Amount Sent (<?php echo e($conversion['currency']); ?>)</label>
                        <input type="number" name="amount" class="form-control" required>
                    </div>
                    
                    <button type="submit" class="btn btn-submit">
                        <i class="bi bi-check-circle-fill me-2"></i> Confirm Payment
                    </button>
                </form>
            </div>
        </div>
        
    <?php else: ?>
        <div class="payment-method-card">
            <div class="card-header">
                <i class="bi bi-currency-bitcoin me-2"></i> USDT (TRC20) Deposit
            </div>
            <div class="card-body">
                <p class="mb-4">Send USDT (TRC20) to the wallet address below and upload proof of payment.</p>
                
                <div class="wallet-address-container">
                    <div class="wallet-address" id="walletAddress">TQq1zVosHkaGgc9TszEDeFhdHL2tVsB6od</div>
                    <button onclick="copyToClipboard('TQq1zVosHkaGgc9TszEDeFhdHL2tVsB6od')" class="btn btn-primary">
                        <i class="bi bi-clipboard"></i> Copy
                    </button>
                </div>
                
                <div class="alert alert-info">
                    <i class="bi bi-info-circle-fill me-2"></i> Please ensure you send only USDT via TRC20 network
                </div>
                
                <form action="<?php echo e(route('deposit')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="email" value="<?php echo e($user->email); ?>">
                    <input type="hidden" name="phone" value="<?php echo e($user->phone); ?>">
                    <input type="hidden" name="username" value="<?php echo e($user->username); ?>">
                    <input type="hidden" name="country" value="<?php echo e($user->country); ?>">
                    
                    <div class="mb-3">
                        <label class="form-label">Upload Transaction Hash/Proof</label>
                        <input type="file" name="images" class="form-control" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Amount (USDT)</label>
                        <input type="number" name="amount" class="form-control" step="0.01" required>
                    </div>
                    
                    <button type="submit" class="btn btn-submit">
                        <i class="bi bi-check-circle-fill me-2"></i> Confirm Deposit
                    </button>
                </form>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
    // Auto-hide alerts after 5 seconds
    setTimeout(() => {
        document.querySelectorAll('.alert').forEach(alert => {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(() => alert.remove(), 500);
        });
    }, 5000);

    // Copy to clipboard function
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(() => {
            alert('Copied to clipboard: ' + text);
        }).catch(err => {
            console.error('Failed to copy: ', err);
        });
    }
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/cdp24.site/resources/views/user/deposit.blade.php ENDPATH**/ ?>