<?php $__env->startSection('content'); ?>

<?php
    $packages = DB::table('packages')->get();
    
   $interns = DB::table('invest')->where('user_id', Auth::user()->id)->where('capital', 200)->get()->count();
   
   $hideIntern = false;
   
   if($interns >= 2){
       $hideIntern = "true";
   }

?>


<!-- Page Title -->
<div class="text-center my-4">
    <h2 class="fw-bold">Choose Job Level</h2>
</div>

<!-- Package Display -->
<div class="container">
    <div class="row g-4">
         <?php if(Session::has('success')): ?>
            <div class="alert alert-success text-sm text-center" role="alert">
                <?php echo e(Session::get('success')); ?>

            </div>
        <?php endif; ?>
    
        <!-- Display Error Message -->
        <?php if(Session::has('error')): ?>
            <div class="alert alert-danger text-sm text-center" role="alert">
                <?php echo e(Session::get('error')); ?>

            </div>
        <?php endif; ?>
            
        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php if($pkg->price == 200 && $hideIntern == "true"): ?>
              <div class="col-md-4 ">
                  <div class="card shadow-sm ">
                    
                    <center>
                        <b>You have finished intern level</b><br>
                        <small>Upgrade to next job level</small>
                    </center>
                   
                  </div>
              </div>
          <?php else: ?>
         
            <div class="col-md-4 ">
                <div class="card shadow-lg border-0">
                    <div class="card-header position-relative bg-success text-white text-center fw-bold">
                         <?php echo e($pkg->days); ?> days
                        <?php if($pkg->vip): ?>
                            <span class="position-absolute top-0 end-0 bg-warning text-light fw-bold px-3 py-1 rounded-pill m-1">
                               <?php echo e($pkg->vip); ?> job
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="card-body text-start">
                        <h3 class="text-info fw-bold"> <?php echo e($settings->currency); ?> <?php echo e(number_format($pkg->price  * $settings->rate, 2)); ?></h3>
                        <p class="text-muted mb-2">Daily Income:  <?php echo e($settings->currency); ?> <?php echo e(number_format($pkg->daily_income  * $settings->rate, 2)); ?></p>
                        <p class="fw-bold">Tasks per day: <?php echo e($pkg->daily_tasks); ?></p>
                        <p>Total Salary: <span class="fw-bold text-info"> <?php echo e($settings->currency); ?> <?php echo e(number_format($pkg->daily_income * $pkg->days  * $settings->rate, 2)); ?></span></p>
                        <div class="d-flex justify-content-between align-items-center mt-4">
                            <a href="<?php echo e(url('package?p=' . $pkg->id)); ?>" class="w-100 btn btn-success w-75">
                                Start Now
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sahuapp.work/public_html/resources/views/investment.blade.php ENDPATH**/ ?>