<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title><?php echo e(env('APP_NAME')); ?> - Finance</title>
    <link rel="stylesheet" type="text/css" href="public/styles/bootstrap.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
	 <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@500;600;700&family=Roboto:wght@400;500;700&display=swap"
        rel="stylesheet">
    <link rel="manifest" href="_manifest.json">
    <meta id="theme-check" name="theme-color" content="#FFFFFF">
    <link rel="apple-touch-icon" sizes="180x180" href="public/app/icons/icon-192x192.png">

</head>

<body class="theme-light">
    <?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="preloader">
        <div class="spinner-border color-highlight" role="status"></div>
    </div>

    <div id="page">

        <div id="footer-bar" class="footer-bar-1 footer-bar-detached">
            <a href="profile"><i class="bi bi-person"></i><span>Profile</span></a>
            <a href="transactions"><i class="bi bi-graph-up"></i><span>Activity</span></a>
            <a href="home" class="circle-nav-2"><i class="bi bi-house-fill"></i><span>Home</span></a>
            <a href="vip"><i class="bi bi-receipt"></i><span>Products</span></a>
            <a href="https://apk.e-droid.net/apk/app3131146-rv7ml4.apk?v=1" ><i
                    class="bi bi-three-dots"></i><span>App</span></a>
        </div>

        <div class="page-content footer-clear">

            <div class="pt-3">
                <div class="page-title d-flex">
                    <div class="align-self-center me-auto">
                        <p class="color-highlight header-date"></p>
                        <h1>Welcome</h1>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-notifications"
                            class="icon gradient-blue color-white shadow-bg shadow-bg-xs rounded-m">
                            <i class="bi bi-bell-fill font-17"></i>
                            <em class="badge bg-red-dark color-white scale-box">3</em>
                        </a>
                        <a href="#" data-bs-toggle="dropdown"
                            class="icon gradient-blue shadow-bg shadow-bg-s rounded-m">
                            <img src="public/user.png" width="45" class="rounded-m" alt="img">
                        </a>

                        <div class="dropdown-menu">
                            <div class="card card-style shadow-m mt-1 me-1">
                                <div class="list-group list-custom list-group-s list-group-flush rounded-xs px-3 py-1">
                                    <a href="deposit" class="list-group-item">
                                        <i
                                            class="has-bg gradient-green shadow-bg shadow-bg-xs color-white rounded-xs bi bi-credit-card"></i>
                                        <strong class="font-13">Deposit</strong>
                                    </a>
                                    <a href="withdraw" class="list-group-item">
                                        <i
                                            class="has-bg gradient-blue shadow-bg shadow-bg-xs color-white rounded-xs bi bi-graph-up"></i>
                                        <strong class="font-13">Cashout</strong>
                                    </a>
                                    <a href="profile" class="list-group-item">
                                        <i
                                            class="has-bg gradient-yellow shadow-bg shadow-bg-xs color-white rounded-xs bi bi-person-circle"></i>
                                        <strong class="font-13">Account</strong>
                                    </a>
                                    <a href="https://wa.me/+250738088231" class="list-group-item">
                                        <i class="has-bg gradient-green shadow-bg shadow-bg-xs color-white rounded-xs bi bi-whatsapp"></i>
                                        <strong class="font-13">Support</strong>
                                    </a>
                                    <a href="logout" class="list-group-item">
                                        <i
                                            class="has-bg gradient-red shadow-bg shadow-bg-xs color-white rounded-xs bi bi-power"></i>
                                        <strong class="font-13">Log Out</strong>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="splide single-slider slider-no-dots slider-no-arrows slider-visible" id="single-slider-1">
                <div class="splide__track">
                    <div class="splide__list">
                        <?php 
                            $ps = DB::table('packages')->get();
                        ?>
                        <?php $__currentLoopData = $ps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="splide__slide">
                            <div class="card card-style m-0 bg-5 shadow-card shadow-card-m" style="height:200px">
                                <div class="card-top p-3">
                                   <div class="text-end text-light">PRICE.<b>KES.<?php echo e(number_format($p->price, 2)); ?></b></div>  
                                </div>
                                <div class="card-center">
                                    <div class="bg-theme px-3 py-2 rounded-end d-inline-block">
                                        <h1 class="font-13 my-n1">
                                            <a class="color-theme"  href="package?p=<?php echo e($p->id); ?>"
                                                aria-controls="balance2">Order this product</a>
                                        </h1>
                                        <div  id="">
                                            <a href="package?p=<?php echo e($p->id); ?>">
                                            <h2 class="color-theme font-26">KES.<?php echo e($p->price); ?></h2>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <strong
                                    class="card-top no-click font-12 p-3 color-white font-monospace"><?php echo e($p->vip); ?></strong>
                                <strong class="card-bottom no-click p-3 text-start color-white font-monospace">Daily
                                    Income:KES<?php echo e($p->daily_income); ?></strong>
                                <strong
                                    class="card-bottom no-click p-3 text-end color-white font-monospace"><?php echo e($p->days); ?>Days</strong>
                                <div class="card-overlay bg-black opacity-50"></div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>

            <div class="content py-2">
                <div class="d-flex text-center">
                    <div class="me-auto">
                        <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-transfer"
                            class="icon icon-xxl rounded-m bg-theme shadow-m"><i
                                class="font-28 color-green-dark bi bi-arrow-up-circle"></i></a>
                        <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Recharge</h6>
                    </div>
                    <div class="m-auto">
                        <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-request"
                            class="icon icon-xxl rounded-m bg-theme shadow-m"><i
                                class="font-28 color-red-dark bi bi-arrow-down-circle"></i></a>
                        <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Withdraw</h6>
                    </div>
                    <div  class="m-auto">
                        <a href="vip" class="icon icon-xxl rounded-m bg-theme shadow-m"><i
                                class="font-28 color-blue-dark bi bi-arrow-repeat"></i></a>
                        <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Products</h6>
                    </div>
                    <div class="ms-auto">
                        <a href="downlines" class="icon icon-xxl rounded-m bg-theme shadow-m"><i
                                class="font-28 color-brown-dark bi bi-filter-circle"></i></a>
                        <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Teams</h6>
                    </div>
                </div>
            </div>
            
            
            
            <?php
            
            $daily_icome=DB::table('invest')->where('user_id', Auth::user()->id)->sum('returns');
            
            
            
            ?>
            
                <div class="card card-style">
                    <div class="row">
                        <div class="col-12">
                            <div class="card p-3">
                               
                                <h4 class="fw-bold fs-5">ACCOUNT INFORMATION</h4>
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-8">
                                        <p class="fw-normal mb-0">crypto wallet Balance:</p>
                                    </div>
                                    <div class="col-4 text-end">
                                        <p class="fw-bold mb-0">KES.<?php echo e(Auth::user()->balance); ?></p>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-8">
                                        <p class="fw-normal mb-0">Your Investment:</p>
                                    </div>
                                    <div class="col-4 text-end">
                                        <p class="fw-bold mb-0">KES.<?php echo e(Auth::user()->investments); ?></p>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-8">
                                        <p class="fw-normal mb-0">Daily Yield:</p>
                                    </div>
                                    <div class="col-4 text-end">
                                        <p class="fw-bold mb-0">KES.<?php echo e(number_format($daily_icome, 2)); ?></p>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-8">
                                        <p class="fw-normal mb-0">Total Revenue:</p>
                                    </div>
                                    <div class="col-4 text-end">
                                        <p class="fw-bold mb-0">KES.<?php echo e(number_format($daily_icome * 29, 2)); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <div class="content my-0 mt-n2 px-1">
                <div class="d-flex">
                    <div class="align-self-center">
                        <h3 class="font-16 mb-2">Recent Activity</h3>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="transactions" class="font-12 pt-1">View All</a>
                    </div>
                </div>
            </div>
            
         

            <div class="card card-style">
                <div class="content">
             <?php
                    $transactions = \DB::table('deposits')
                        ->select(
                            'deposits.created_at as date',
                            'deposits.amount',
                            'deposits.status',
                            \DB::raw("'deposit' as type"),
                        )
                        ->where('deposits.username', '=', Auth::user()->username)
                        ->union(
                            \DB::table('cashouts')
                                ->select(
                                    'cashouts.created_at as date',
                                    'cashouts.amount',
                                    'cashouts.status',
                                    \DB::raw("'cashout' as type"),
                                )
                                ->where('cashouts.username', '=', Auth::user()->username),
                        )
                        ->latest('date') // Order by the 'date' column in descending order
                        ->limit(4) // Limit to the latest 4 records
                        ->get();
                ?>
                <?php if($transactions->count() > 0): ?>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="transactions" class="d-flex py-1">
                        <div class="align-self-center">
                             <span class="icon rounded-s me-2 <?php if($trx->type == 'cashout'): ?> gradient-orange <?php else: ?> gradient-green <?php endif; ?> gradient-orange shadow-bg shadow-bg-s">
                                <i class="bi bi-caret-up-fill color-white"></i>
                            </span>
                        </div>
                        <div class="align-self-center ps-1">
                            <h5 class="pt-1 mb-n1">
                                <?php echo e($trx->type); ?></h5>
                            <p class="mb-0 font-11 opacity-50"><?php echo e($trx->date); ?> <span class="copyright-year"></span></p>
                        </div>
                        <div class="align-self-center ms-auto text-end">
                            <h4 class="pt-1 mb-n1  <?php if($trx->type == 'cashout'): ?> color-red-dark <?php else: ?> color-green <?php endif; ?>">KES.<?php echo e($trx->amount); ?></h4>
                            <p class="mb-0 font-11">Bill Payment</p>
                        </div>
                    </a>
                    <div class="divider my-2 opacity-50"></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <center class="">
                    <div class="row bg-gray-400 m-2 p-2" style="background-color:#C2C4D1;border-radius:8px;">
                        <p>No Transactions yet</p>
                    </div>
                </center>
                <?php endif; ?>
                </div>
            </div>

            <div class="content my-0 mt-n2 px-1">
                <div class="d-flex">
                    <div class="align-self-center">
                        <h3 class="font-16 mb-2">Account Activity</h3>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="home" class="font-12 pt-1">View All</a>
                    </div>
                </div>
            </div>
          <?php if(session('success')): ?>
            <div class="card card-style gradient-green shadow-bg shadow-bg-s">
                <div class="content">

                          <a href="transactions" class="d-flex">
                            <div class="align-self-center">
                                <h1 class="mb-0 font-40"><i class="bi bi-check-circle color-white pe-3"></i></h1>
                            </div>
                            <div class="align-self-center">
                                <h5 class="color-white font-700 mb-0 mt-0 pt-1">
                                    <?php echo e(session('success')); ?>

                                </h5>
                            </div>
                            <div class="align-self-center ms-auto">
                                <i class="bi bi-arrow-right-short color-white d-block pt-1 font-20 opacity-50"></i>
                            </div>
                                   
                         </a>

                </div>
            </div>
            <?php else: ?>
            <div class="card-style gradient-green shadow-bg shadow-bg-s">
               <center>
                   <p class="mt-2">
                       No Activity Yet
                   </p>
               </center>
             </div>
             <?php endif; ?>
             <?php if(session('error')): ?>
              <div class="card card-style gradient-green shadow-bg shadow-bg-s">
                <div class="content">
                          <a href="transactions" class="d-flex">
                            <div class="align-self-center">
                                <h1 class="mb-0 font-40"><i class="bi bi-check-circle color-white pe-3"></i></h1>
                            </div>
                            <div class="align-self-center">
                                <h5 class="color-white font-700 mb-0 mt-0 pt-1">
                                    <?php echo e(session('error')); ?>

                                </h5>
                            </div>
                            <div class="align-self-center ms-auto">
                                <i class="bi bi-arrow-right-short color-white d-block pt-1 font-20 opacity-50"></i>
                            </div>
                                   
                         </a>
                </div>
            </div>
           <?php endif; ?>

            <div class="content mb-0">
                <div class="d-flex">
                    <div class="align-self-center">
                        <h3 class="font-16 mb-2">Teams Overview</h3>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="downlines" class="font-12 pt-1">View All</a>
                    </div>
                </div>
            </div>

            <div class="splide quad-slider slider-no-dots slider-no-arrows slider-visible text-center"
                id="double-slider-2">
                <div class="splide__track">
                    <div class="splide__list">
                        <?php 
                        
                         $teams = DB::table('users')->where('upline', Auth::user()->ref_code)->get();
                         $it = 1;
                        ?>
                        <?php if($teams->count() > 0): ?>
                        <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $it = $it +1; ?>
                        <div class="ml-0 pl-0">
                            <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-friends-transfer"
                                data-card-height="60"
                                class="card border-0  bg-<?php echo e($it); ?> shadow-card shadow-card-m rounded-m"></a>
                            <h6 class="pt-2 font-600"><?php echo e($t->phone); ?></h6>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <center>
                            <p>No Team Yet</p>
                        </center>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>




        <div id="menu-sidebar" data-menu-active="nav-welcome" data-menu-load="wallet"
            class="offcanvas offcanvas-start offcanvas-detached rounded-m">
        </div>

        <div id="menu-highlights" data-menu-load="menu-highlights"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-notifications" data-menu-load="menu-notifications"
            class="offcanvas offcanvas-top offcanvas-detached rounded-m">
        </div>

        <div id="menu-card-more" data-menu-load="menu-card-settings"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-transfer" data-menu-load="deposit"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-friends-transfer" data-menu-load="menu-friends-transfer"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-request" data-menu-load="withdraw"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-exchange" data-menu-load="menu-exchange"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>
        <div class="offcanvas offcanvas-bottom rounded-m offcanvas-detached" id="menu-install-pwa-ios">
            <div class="content">
                <img src="app/icons/icon-128x128.png" alt="img" width="80" class="rounded-m mx-auto my-4">
                <h1 class="text-center">Install <?php echo e(env('APP_NAME')); ?></h1>
                <p class="boxed-text-xl">
                    Install PayApp on your home screen, and access it just like a regular app. Open your Safari menu and
                    tap "Add to Home Screen".
                </p>
                <a href="#"
                    class="pwa-dismiss close-menu color-theme text-uppercase font-900 opacity-50 font-11 text-center d-block mt-n2"
                    data-bs-dismiss="offcanvas">Maybe Later</a>
            </div>
        </div>
        <div class="offcanvas offcanvas-bottom rounded-m offcanvas-detached" id="menu-install-pwa-android">
            <div class="content">
                <img src="app/icons/icon-128x128.png" alt="img" width="80" class="rounded-m mx-auto my-4">
                <h1 class="text-center">Install PayApp</h1>
                <p class="boxed-text-l">
                    Install PayApp to your Home Screen to enjoy a unique and native experience.
                </p>
                <a href="#"
                    class="pwa-install btn btn-m rounded-s text-uppercase font-900 gradient-highlight shadow-bg shadow-bg-s btn-full">Add
                    to Home Screen</a><br>
                <a href="#" data-bs-dismiss="offcanvas"
                    class="pwa-dismiss close-menu color-theme text-uppercase font-900 opacity-60 font-11 text-center d-block mt-n1">Maybe
                    later</a>
            </div>
        </div>
    </div>

    <script src="public/scripts/bootstrap.min.js"></script>
    <script src="public/scripts/custom.js"></script>
</body><?php /**PATH /home/uniquesq/cryptocoin.nakaa.com.ng/resources/views/user/dashboard.blade.php ENDPATH**/ ?>