<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title><?php echo e(env('APP_NAME')); ?> - Finance</title>
    <link rel="stylesheet" type="text/css" href="public/styles/bootstrap.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@500;600;700&family=Roboto:wght@400;500;700&display=swap"
        rel="stylesheet">
    <link rel="manifest" href="_manifest.json">
    <meta id="theme-check" name="theme-color" content="#FFFFFF">
    <link rel="apple-touch-icon" sizes="180x180" href="public/app/icons/icon-192x192.png">

</head>

<body class="theme-light">
    <?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="preloader">
        <div class="spinner-border color-highlight" role="status"></div>
    </div>

    <div id="page">

        <div id="footer-bar" class="footer-bar-1 footer-bar-detached">
            <a href="profile"><i class="bi bi-person"></i><span>Profile</span></a>
            <a href="transactions"><i class="bi bi-graph-up"></i><span>Activity</span></a>
            <a href="home" class="circle-nav-2"><i class="bi bi-house-fill"></i><span>Home</span></a>
            <a href="vip"><i class="bi bi-receipt"></i><span>Products</span></a>
            <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-sidebar"><i
                    class="bi bi-three-dots"></i><span>More</span></a>
        </div>

        <div class="page-content footer-clear">

            <div class="pt-3">
                <div class="page-title d-flex">
                    <div class="align-self-center me-auto">
                        <p class="color-highlight">Hello <?php echo e(Auth::user()->username); ?></p>
                        <h1 class="color-theme">Products</h1>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-add-card"
                            class="icon gradient-green color-white shadow-bg shadow-bg-xs rounded-m">
                            <i class="bi bi-plus-circle font-17"></i>
                        </a>
                     
                      
                    </div>
                </div>
            </div>
            
              <!-- Display Packages -->
            <?php if($errors->any()): ?>
            <div class="alert alert-danger m-2">
                <h4><?php echo e($errors->first()); ?></h4>
            </div>
            <?php endif; ?>

            <?php if(\Session::has('success')): ?>
            <div class="alert alert-success m-2">
                <h4><?php echo \Session::get('success'); ?></h4>
            </div>
            <?php endif; ?>

            <?php if(\Session::has('error')): ?>
            <div class="alert alert-danger m-2">
                <h4><?php echo \Session::get('error'); ?></h4>
            </div>
            <?php endif; ?>

            <div class="card-stack" data-stack-height="180">
                
                <div class="card-stack-click"></div>
                
                <?php
                       $packages = DB::table('packages')->get();
                ?>
                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                <div class="card card-style bg-5">
                    <div class="card-top p-3 text-end text-white h5">
                      Price:<b><?php echo e(number_format($pkg->price, 2)); ?></b>(kes)
                    </div>
                    <div class="card-center">
                        <div class="bg-info px-3 py-2 rounded-end d-inline-block">
                            <h1 class="font-13 my-n1">
                                <a class="color-theme text-white"  href="package?p=<?php echo e($pkg->id); ?>"
                                    aria-controls="balance2">ORDER NOW</a>
                            </h1>
                            <div class="">
                                <a href="package?p=<?php echo e($pkg->id); ?>">
                                  <h2 class="color-theme font-26">KES.<?php echo e($pkg->price); ?></h2>  
                                </a>
                                
                            </div>
                        </div>
                    </div>
                    <strong class="card-top no-click font-12 p-3 color-white font-monospace"><?php echo e($pkg->vip); ?></strong>
                    <strong class="card-bottom no-click p-3 text-start color-white font-monospace">Daily Income:KES.<?php echo e($pkg->daily_income); ?></strong>
                    <strong class="card-bottom no-click p-3 text-end color-white font-monospace"><?php echo e($pkg->days); ?>Days</strong>
                    <div class="card-overlay bg-black opacity-50"></div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <h6 class="btn-stack-info color-theme opacity-80 text-center mt-n2 mb-3">Tap To See More Products
            </h6>

            <a href="#"
                class="disabled btn-stack-click btn mx-3 mb-4 btn-full gradient-highlight shadow-bg shadow-bg-xs">Close
                my packages</a>

        </div>




        <div id="menu-sidebar" data-menu-active="nav-pages" data-menu-load="menu-sidebar.html"
            class="offcanvas offcanvas-start offcanvas-detached rounded-m">
        </div>

        <div id="menu-highlights" data-menu-load="menu-highlights.html"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-add-card" data-menu-load="deposit"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-card-more" data-menu-load="deposit"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-notifications" data-menu-load="menu-notifications.html"
            class="offcanvas offcanvas-top offcanvas-detached rounded-m">
        </div>
    </div>

    <script src="public/scripts/bootstrap.min.js"></script>
    <script src="public/scripts/custom.js"></script>
</body><?php /**PATH /home/uniquesq/cash-mining.nakaa.com.ng/resources/views/investment.blade.php ENDPATH**/ ?>