<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="generator" content="">
    <title><?php echo e(config('app.name')); ?></title>



    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- bootstrap icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">


    <!-- style css for this template -->
    <link href="<?php echo e(env('APP_NAME')); ?>/assets/css/style.css" rel="stylesheet">
    <!--tailwind css 3-->
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="body-scroll" data-page="addmoney">

    <!-- loader section -->


    <!-- Begin page -->
    <main class="h-screen m-1 pt-1">

        <!-- Header -->
        <header class="fixed top-0 left-0 right-0 text-white  p-4 z-10">
            <div class="flex items-center justify-between">
                <div class="">
                    <a href="home">
                        <button type="button" class="bg-gray-100 shadow rounded-lg text-gray-700 px-2 font-bold">
                            <i class="bi bi-arrow-left"></i>
                        </button>
                    </a>
                </div>

            </div>
        </header>
        <!--Header ends -->
        <?php

            // In your controller or wherever you need this query
            $transactions = \DB::table('users') // Limit to the latest 4 records
                ->where('ref_code', Auth::user()->ref_code)
                ->get();

        ?>
        <!--main page content -->
        <div class="mt-12 container">
            <center>
            <code class="badge">Your Invite Link</code>
            </center>
            <div class="flex items-center justify-center">
              
                <div class="bg-gray-200 p-6 rounded-lg shadow-lg">
                    <input type="text" id="referralLink" class="w-full border-gray-300 rounded-md p-2 mb-4"
                        value="<?php echo e(env('APP_URL')); ?>/register?ref_code=<?php echo e(Auth::user()->ref_code); ?>" readonly>
                    <button id="copyButton"
                        class="bg-blue-500 text-white px-4 py-2 rounded-md hover:bg-blue-600 focus:outline-none">Copy</button>
                </div>
            </div>
            <script>
                document.getElementById('copyButton').addEventListener('click', function() {
                    var referralLink = document.getElementById('referralLink');
                    referralLink.select();
                    document.execCommand('copy');
                    alert('Copied the referral link: ' + referralLink.value);
                });
            </script>
            <br>
            <?php if($transactions->count() > 0): ?>
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <h6 class="title m-2">Downlines Invited</h6>
                        <small class="text-muted m-2">Upto Today, <?php echo e(date('Y-m-d')); ?></small>
                    </div>
                    <div class="mr-4">
                        <a href="deposit" class="text-sm">+Recharge</a>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-12 px-0">
                        <!-- swiper users connections -->
                        <div class="">
                            <div class="">
                                <?php
                                $people = DB::table('users')
                                    ->where('upline', Auth::user()->ref_code)
                                    ->latest('id')
                                    ->get();
                                ?>
                                <?php if($people->count() > 0): ?>
                                    <?php $__currentLoopData = $people; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mx-3 m-1">
                                            <div class="bg-gray-300 h-12 w-full rounded pt-2 text-center">
                                                <div class="flex p-1 justify-evenly">
                                                    <!-- Apply Tailwind CSS badge -->
                                                    <span
                                                        class="inline-flex items-center px-3 py-0.5 rounded-full text-xs font-medium leading-4 <?php echo e($p->investments > 0 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                                        <?php echo e($p->investments > 0 ? 'Active' : 'Inactive'); ?>

                                                    </span>
                                                    <p><?php echo e($p->username); ?></p>
                                                    <p><?php echo e($p->phone); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>


                    </div>
                </div>
            <?php else: ?>
                <div class="text-center">
                    <p>No team build yet</p>
                </div>
            <?php endif; ?>
        </div>
        <!-- main page content ends -->


    </main>

</body>

</html>
<?php /**PATH /home/nakamoto/Desktop/webs/etica/resources/views/user/downlines.blade.php ENDPATH**/ ?>