<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title><?php echo e(env('APP_NAME')); ?> - Finance</title>
    <link rel="stylesheet" type="text/css" href="public/styles/bootstrap.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
	 <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@500;600;700&family=Roboto:wght@400;500;700&display=swap"
        rel="stylesheet">
    <link rel="manifest" href="_manifest.json">
    <meta id="theme-check" name="theme-color" content="#FFFFFF">
    <link rel="apple-touch-icon" sizes="180x180" href="public/app/icons/icon-192x192.png">
    <style>
  #withdraw-notification {
    display: flex;
    justify-content: center; /* Centers horizontally */
    align-items: center; /* Centers vertically */

    text-align: center; /* Ensures text is centered inside the div */

  }

  #withdraw-message {
    color: green; /* Set text color to green */
  }
</style>


</head>

<body class="theme-secondary">
    <?php echo $__env->make('script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="preloader">
        <div class="spinner-border color-primary" role="status"></div>
    </div>

    <div id="page">

        <div id="footer-bar" class="footer-bar-1 footer-bar-detached mr-1">
            <a href="profile"><i class="bi bi-person"></i><span>Profile</span></a>
            <a href="transactions"><i class="bi bi-graph-up"></i><span>Activity</span></a>
            <a href="home" class="circle-nav-2"><i class="bi bi-house-fill"></i><span>Home</span></a>
            <a href="vip"><i class="bi bi-receipt"></i><span>Products</span></a>
            <a href="videos" ><i
                    class="bi bi-youtube"></i><span>Videos</span></a>
        </div>
         <!-- Notification Container -->
        <div id="withdraw-notification">
            <p id="withdraw-message"></p>
        </div>
        
        <div class="page-content footer-clear">

            <div class="pt-3">
                <div class="page-title d-flex">
                    <div class="align-self-center me-auto">
                        <p class="color-highlight header-date"></p>
                        <h1>Welcome</h1>
                   
                       <div> </a>
                        <a href="#" data-bs-toggle="dropdown"
                        class="bi bi-list-task heihgt-10px width-10px"
                            <i class="bi bi-list-task"></i>
                            
                        </a>

                        <div class="dropdown-menu">
                            <div class="card card-style shadow-m mt-1 me-1">
                                <div class="list-group list-custom list-group-s list-group-flush rounded-xs px-3 py-1">
                                    <a href="deposit" class="list-group-item">
                                       <a href="#" class="center-container">
                                           <i class="has-bg gradient-green shadow-bg shadow-bg-xs color-white rounded-xs bi bi-credit-card"></i>
                                            <strong class="font-13">Deposit</strong>
                                      </a>

                                    <a href="withdraw" class="list-group-item">
                                        <i
                                            class="has-bg gradient-blue shadow-bg shadow-bg-xs color-white rounded-xs bi bi-graph-up"></i>
                                        <strong class="font-13">Cashout</strong>
                                    </a>
                                    <a href="profile" class="list-group-item">
                                        <i
                                            class="has-bg gradient-yellow shadow-bg shadow-bg-xs color-white rounded-xs bi bi-person-circle"></i>
                                        <strong class="font-13">Account</strong>
                                    </a>
                                    <a href="" class="list-group-item">
                                        <i class="has-bg gradient-green shadow-bg shadow-bg-xs color-white rounded-xs bi bi-whatsapp"></i>
                                        <strong class="font-13">Support</strong>
                                    </a>
                                    <a href="logout" class="list-group-item">
                                        <i
                                            class="has-bg gradient-red shadow-bg shadow-bg-xs color-white rounded-xs bi bi-power"></i>
                                        <strong class="font-13">Log Out</strong>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="splide single-slider slider-no-dots slider-no-arrows slider-visible" id="single-slider-1">
                <div class="splide__track">
                    <div class="splide__list">
                        <?php 
                            $ps = DB::table('packages')->get();
                        ?>
                        <?php $__currentLoopData = $ps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="splide__slide">
                            <div class="card card-style m-0 bg-5 shadow-card shadow-card-m" style="height:200px">
                                <div class="card-top p-3">
                                   <div class="text-end text-light">PRICE.<b>KES.<?php echo e(number_format($p->price, 2)); ?></b></div>  
                                </div>
                                <div class="card-center">
                                    <div class="bg-theme px-3 py-2 rounded-end d-inline-block">
                                        <h1 class="font-13 my-n1">
                                            <a class="color-theme"  href="package?p=<?php echo e($p->id); ?>"
                                                aria-controls="balance2">Order this product</a>
                                        </h1>
                                        <div  id="">
                                            <a href="package?p=<?php echo e($p->id); ?>">
                                            <h2 class="color-theme font-26">KES.<?php echo e($p->price); ?></h2>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <strong
                                    class="card-top no-click font-12 p-3 color-green font-monospace"><?php echo e($p->vip); ?></strong>
                                <strong class="card-bottom no-click p-3 text-start color-white font-monospace">Daily
                                    Income:KES<?php echo e($p->daily_income); ?></strong>
                                <strong
                                    class="card-bottom no-click p-3 text-end color-white font-monospace"><?php echo e($p->days); ?>Days</strong>
                                <div class="card-overlay bg-black opacity-50"></div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>

            <div class="content py-2">
                <div class="d-flex text-center">
                    <div class="me-auto">
                        <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-transfer"
                            class="icon icon-xxl rounded-m bg-theme shadow-m"><i
                                class="font-28 color-green-dark bi bi-arrow-up-circle"></i></a>
                        <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Recharge</h6>
                    </div>
                    <div class="m-auto">
                        <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-request"
                            class="icon icon-xxl rounded-m bg-theme shadow-m"><i
                                class="font-28 color-red-dark bi bi-arrow-down-circle"></i></a>
                        <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Withdraw</h6>
                    </div>
                    
                    <div class="ms-auto">
                        <a href="downlines" class="icon icon-xxl rounded-m bg-theme shadow-m"><i
                                class="font-28 color-brown-dark bi bi-filter-circle"></i></a>
                        <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Teams</h6>
                    </div>
                    <div class="col-auto me-auto">
                <div class="icon-wrapper">
                    <!-- WhatsApp Icon -->
                    <a href="https://chat.whatsapp.com/HbM4FxwlbMfLD9tCauLIpx" target="_blank" class="icon icon-xxl rounded-circle bg-theme shadow-m">
                        <i class="font-28 color-whatsapp bi bi-whatsapp"></i>
                    </a>
                    <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">WhatsApp</h6>
                </div>
            </div>
                     <div class="col-auto me-auto">
                <div class="icon-wrapper">
                    <!-- Telegram Icon -->
                    <a href="https://t.me/clarityinvestnents" target="_blank" class="icon icon-xxl rounded-circle bg-theme shadow-m d-flex align-items-center justify-content-center">
                        <i class="font-28 color-telegram bi bi-telegram"></i>
                    </a>
                    <h6 class="font-13 opacity-80 font-500 mb-0 pt-2">Telegram</h6>
                </div>
            </div>
                </div>
            </div>
            
            
            
            <?php
            
            $daily_icome=DB::table('invest')->where('user_id', Auth::user()->id)->sum('returns');
            
            
            
            ?>
            
    <div class="card card-style" id="animated-bg">
    <div class="row">
        <div class="col-12">
            <div class="card p-3">
                <h4 class="fw-bold fs-5" style="text-align: center; font-style: italic; color: brown;">ACCOUNT INFORMATION</h4>
                <hr>
                <div class="row mb-2">
                 <div class="row mb-2">
    <div class="col-8">
        <p class="fw-bold mb-0"><span style="color: black;">invest balance:</span></p>
    </div>
    <div class="col-4 text-end">
        <p class="fw-bold mb-0"><span style="color: black;">KES.<?php echo e(Auth::user()->balance); ?></span></p>
    </div>
</div>
              <div class="row mb-2">
    <div class="col-8">
        <p class="fw-bold mb-0"><span style="color: black;">youtube balance:</span></p>
    </div>
    <div class="col-4 text-end">
        <p class="fw-bold mb-0"><span style="color: black;">KES.<?php echo e(Auth::user()->youtube); ?></span></p>
    </div>
</div>
<div class="row mb-2">
    <div class="col-8">
        <p class="fw-bold mb-0"><span style="color: black;">Your Investment:</span></p>
    </div>
    <div class="col-4 text-end">
        <p class="fw-bold mb-0"><span style="color: black;">KES.<?php echo e(Auth::user()->investments); ?></span></p>
    </div>
</div>
<div class="row mb-2">
    <div class="col-8">
        <p class="fw-bold mb-0"><span style="color: black;">Daily Yield:</span></p>
    </div>
    <div class="col-4 text-end">
        <p class="fw-bold mb-0"><span style="color: black;">KES.<?php echo e(number_format($daily_icome, 2)); ?></span></p>
    </div>
</div>
<div class="row mb-3">
    <div class="col-8">
        <p class="fw-bold mb-0"><span style="color: black;">Total Revenue:</span></p>
    </div>
    <div class="col-4 text-end">
        <p class="fw-bold mb-0"><span style="color: black;">KES.<?php echo e(number_format($daily_icome * 29, 2)); ?></span></p>
    </div>
</div>

                </div>
            </div>
        </div>
    </div>
</div>



<div class="overfloat" id="gui_kai" style="max-width: 450px; margin: 0 auto;">
    <div class="guize_html">
        <div class="guize_html_nei">
            <div style="text-align: center; margin-top: 10px;">
                <img width="32" height="32" src="https://img.icons8.com/external-outline-design-circle/66/external-46-business-and-investment-outline-design-circle.png" alt="external-46-business-and-investment-outline-design-circle"/>
            </div>
            <div class="animated-bg">
                <div class="content">
                    <h3 style="text-align: center; text-decoration: underline; margin-bottom: 20px;">About Clarity investments rules and guidelines to be Considered</h3>
                    <p style="color: #555; text-align: justify;">
                        <h5 style="margin-bottom: 20px; text-align: center; font-style: italic; color: blue;">Welcome 🤗</h5>

                        <p style="font-weight: bold; color: black;">
                            Clarity investments is a fast-growing company that offers an enticing opportunity for users to earn tremendously from their comfort zone by watching daily videos and gat paid or purchasing part of our available products. The seamless interface and user-friendly design make it easy for individuals to participate in tasks that contribute to their earnings.
                        </p>

                        <p>
                            <span class="write"><strong style="color: black;">1. Minimum Deposit:</strong> 500 Ksh</span><br>
                            <span class="write"><strong style="color: black;">2. Minimum Withdrawal:</strong> 100 Ksh</span><br>
                            <span class="write"><strong style="color: black;">3. earn daily with the given rates on our summary of your purchased product daily and also earn with given videos tasks.</strong></span><br>
                            <span class="write"><strong style="color: black;">4. Get a reward of up to 1000 Ksh when you invite 15 or more active members.</strong></span><br>
                            <span class="write"><strong style="color: black;">5. All products can be purchased repeatedly except the 500 and 1000 Ksh product.</strong></span><br>
                            <span class="write"><strong style="color: black;">6. Withdrawals can be made from 9AM to 9PM daily, multiple withdrawals per day.</strong></span>
                        </p>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>


            <div class="content my-0 mt-n2 px-1">
                <div class="d-flex">
                    <div class="align-self-center">
                        <h3 class="font-16 mb-2">Recent Activity</h3>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="transactions" class="font-12 pt-1">View All</a>
                    </div>
                </div>
            </div>
            
         

            <div class="card card-style">
                <div class="content">
             <?php
                    $transactions = \DB::table('deposits')
                        ->select(
                            'deposits.created_at as date',
                            'deposits.amount',
                            'deposits.status',
                            \DB::raw("'deposit' as type"),
                        )
                        ->where('deposits.username', '=', Auth::user()->username)
                        ->union(
                            \DB::table('cashouts')
                                ->select(
                                    'cashouts.created_at as date',
                                    'cashouts.amount',
                                    'cashouts.status',
                                    \DB::raw("'cashout' as type"),
                                )
                                ->where('cashouts.username', '=', Auth::user()->username),
                        )
                        ->latest('date') // Order by the 'date' column in descending order
                        ->limit(4) // Limit to the latest 4 records
                        ->get();
                ?>
                <?php if($transactions->count() > 0): ?>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="transactions" class="d-flex py-1">
                        <div class="align-self-center">
                             <span class="icon rounded-s me-2 <?php if($trx->type == 'cashout'): ?> gradient-orange <?php else: ?> gradient-green <?php endif; ?> gradient-orange shadow-bg shadow-bg-s">
                                <i class="bi bi-caret-up-fill color-white"></i>
                            </span>
                        </div>
                        <div class="align-self-center ps-1">
                            <h5 class="pt-1 mb-n1">
                                <?php echo e($trx->type); ?></h5>
                            <p class="mb-0 font-11 opacity-50"><?php echo e($trx->date); ?> <span class="copyright-year"></span></p>
                        </div>
                        <div class="align-self-center ms-auto text-end">
                            <h4 class="pt-1 mb-n1  <?php if($trx->type == 'cashout'): ?> color-red-dark <?php else: ?> color-green <?php endif; ?>">KES.<?php echo e($trx->amount); ?></h4>
                            <p class="mb-0 font-11">Bill Payment</p>
                        </div>
                    </a>
                    <div class="divider my-2 opacity-50"></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <center class="">
                    <div class="row bg-gray-400 m-2 p-2" style="background-color:#C2C4D1;border-radius:8px;">
                        <p>No Transactions yet</p>
                    </div>
                </center>
                <?php endif; ?>
                </div>
            </div>

            <div class="content my-0 mt-n2 px-1">
                <div class="d-flex">
                    <div class="align-self-center">
                        <h3 class="font-16 mb-2">Account Activity</h3>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="home" class="font-12 pt-1">View All</a>
                    </div>
                </div>
            </div>
          <?php if(session('success')): ?>
            <div class="card card-style gradient-green shadow-bg shadow-bg-s">
                <div class="content">

                          <a href="transactions" class="d-flex">
                            <div class="align-self-center">
                                <h1 class="mb-0 font-40"><i class="bi bi-check-circle color-white pe-3"></i></h1>
                            </div>
                            <div class="align-self-center">
                                <h5 class="color-white font-700 mb-0 mt-0 pt-1">
                                    <?php echo e(session('success')); ?>

                                </h5>
                            </div>
                            <div class="align-self-center ms-auto">
                                <i class="bi bi-arrow-right-short color-white d-block pt-1 font-20 opacity-50"></i>
                            </div>
                                   
                         </a>

                </div>
            </div>
            <?php else: ?>
            <div class="card-style gradient-green shadow-bg shadow-bg-s">
               <center>
                   <p class="mt-2">
                       No Activity Yet
                   </p>
               </center>
             </div>
             <?php endif; ?>
             <?php if(session('error')): ?>
              <div class="card card-style gradient-green shadow-bg shadow-bg-s">
                <div class="content">
                          <a href="transactions" class="d-flex">
                            <div class="align-self-center">
                                <h1 class="mb-0 font-40"><i class="bi bi-check-circle color-white pe-3"></i></h1>
                            </div>
                            <div class="align-self-center">
                                <h5 class="color-white font-700 mb-0 mt-0 pt-1">
                                    <?php echo e(session('error')); ?>

                                </h5>
                            </div>
                            <div class="align-self-center ms-auto">
                                <i class="bi bi-arrow-right-short color-white d-block pt-1 font-20 opacity-50"></i>
                            </div>
                                   
                         </a>
                </div>
            </div>
           <?php endif; ?>

            <div class="content mb-0">
                <div class="d-flex">
                    <div class="align-self-center">
                        <h3 class="font-16 mb-2">Teams Overview</h3>
                    </div>
                    <div class="align-self-center ms-auto">
                        <a href="downlines" class="font-12 pt-1">View All</a>
                    </div>
                </div>
            </div>

            <div class="splide quad-slider slider-no-dots slider-no-arrows slider-visible text-center"
                id="double-slider-2">
                <div class="splide__track">
                    <div class="splide__list">
                        <?php 
                        
                         $teams = DB::table('users')->where('upline', Auth::user()->ref_code)->get();
                         $it = 1;
                        ?>
                        <?php if($teams->count() > 0): ?>
                        <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $it = $it +1; ?>
                        <div class="ml-0 pl-0">
                            <a href="#" data-bs-toggle="offcanvas" data-bs-target="#menu-friends-transfer"
                                data-card-height="60"
                                class="card border-0  bg-<?php echo e($it); ?> shadow-card shadow-card-m rounded-m"></a>
                            <h6 class="pt-2 font-600"><?php echo e($t->phone); ?></h6>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <center>
                            <p>No Team Yet</p>
                        </center>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>




        <div id="menu-sidebar" data-menu-active="nav-welcome" data-menu-load="wallet"
            class="offcanvas offcanvas-start offcanvas-detached rounded-m">
        </div>

        <div id="menu-highlights" data-menu-load="menu-highlights"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-notifications" data-menu-load="menu-notifications"
            class="offcanvas offcanvas-top offcanvas-detached rounded-m">
        </div>

        <div id="menu-card-more" data-menu-load="menu-card-settings"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-transfer" data-menu-load="deposit"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-friends-transfer" data-menu-load="menu-friends-transfer"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-request" data-menu-load="withdraw"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>

        <div id="menu-exchange" data-menu-load="menu-exchange"
            class="offcanvas offcanvas-bottom offcanvas-detached rounded-m">
        </div>
        <div class="offcanvas offcanvas-bottom rounded-m offcanvas-detached" id="menu-install-pwa-ios">
            <div class="content">
                <img src="app/icons/icon-128x128.png" alt="img" width="80" class="rounded-m mx-auto my-4">
                <h1 class="text-center">Install <?php echo e(env('APP_NAME')); ?></h1>
                <p class="boxed-text-xl">
                    Install PayApp on your home screen, and access it just like a regular app. Open your Safari menu and
                    tap "Add to Home Screen".
                </p>
                <a href="#"
                    class="pwa-dismiss close-menu color-theme text-uppercase font-900 opacity-50 font-11 text-center d-block mt-n2"
                    data-bs-dismiss="offcanvas">Maybe Later</a>
            </div>
        </div>
        <div class="offcanvas offcanvas-bottom rounded-m offcanvas-detached" id="menu-install-pwa-android">
            <div class="content">
                <img src="app/icons/icon-128x128.png" alt="img" width="80" class="rounded-m mx-auto my-4">
                <h1 class="text-center">Install PayApp</h1>
                <p class="boxed-text-l">
                    Install PayApp to your Home Screen to enjoy a unique and native experience.
                </p>
                <a href="#"
                    class="pwa-install btn btn-m rounded-s text-uppercase font-900 gradient-highlight shadow-bg shadow-bg-s btn-full">Add
                    to Home Screen</a><br>
                <a href="#" data-bs-dismiss="offcanvas"
                    class="pwa-dismiss close-menu color-theme text-uppercase font-900 opacity-60 font-11 text-center d-block mt-n1">Maybe
                    later</a>
            </div>
        </div>
    </div>
     Notification Container 
    <div id="withdraw-notification">
        <p id="withdraw-message"></p>
    </div>

     Example content 
    <div id="other-content">
        <p>This is the other content that follows below the notification.</p>
    </div>


    <script src="public/scripts/bootstrap.min.js"></script>
    <script src="public/scripts/custom.js"></script>
   <   <!-- Notification Container -->
    <div id="withdraw-notification">
        <p id="withdraw-message"></p>
    </div>

    <script>
        // Function to mask the middle 3 digits of a phone number
        function maskPhoneNumber(phoneNumber) {
            return phoneNumber.slice(0, 4) + "***" + phoneNumber.slice(7);
        }

        // Function to generate a random phone number starting with '07'
        function getRandomPhoneNumber() {
            const phoneNumber = '07' + Math.floor(Math.random() * (99999999 - 10000000 + 1) + 10000000); // Random 9-digit number following '07'
            return maskPhoneNumber(phoneNumber);
        }

        // Function to generate a random amount between KES 100 and KES 10,000
        function getRandomAmount() {
            return Math.floor(Math.random() * (1000 - 100 + 1)) + 100;  // Random amount between 100 and 10,000
        }

        // Function to display the withdrawal notification with sliding effect
        function showWithdrawNotification(amount, phoneNumber) {
            const notification = document.getElementById("withdraw-notification");
            const message = document.getElementById("withdraw-message");
            
            // Set the notification message with phone number and amount in KES
            message.innerHTML = `Phone ${phoneNumber} has withdrawn KES ${amount}`;
            
            // Display the notification and trigger slide-in animation
            notification.style.display = "block";
            notification.style.animation = "slideIn 0.5s forwards";
            
            // Hide the notification after 5 seconds with slide-out animation
            setTimeout(() => {
                notification.style.animation = "slideOut 0.5s forwards";
                setTimeout(() => {
                    notification.style.display = "none";
                }, 500); // Match with slide-out duration
            }, 5000); // Display duration
        }

        // Function to trigger fake withdrawals every 10 seconds
        setInterval(() => {
            const amount = getRandomAmount();
            const phoneNumber = getRandomPhoneNumber();
            showWithdrawNotification(amount, phoneNumber);
        }, 10000);  // Every 10 seconds
    </script>



</body>
</html><?php /**PATH /home/uniquesq/clarityinvestment.antgpt.africa/resources/views/user/dashboard.blade.php ENDPATH**/ ?>