<?php $__env->startSection('content'); ?>
    <style>
        /* Custom styles for overlay */
        .overlay {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(255, 255, 255, 0.5); /* White color with 0.5 opacity */
}

.overlay_1 {
  position: absolute;
  top: 290px; /* Move the overlay 30 pixels above the top */
  left: 0;
  width: 100%;
  height: 60px; /* Adjust height as needed */
  border-radius:6px;
}
        .glass-shading {
            position: absolute;
            background: rgba(255, 255, 255, 0.2);
            width: 100%;
            height: 100%;
            backdrop-filter: blur(10px);
            z-index: 1;
        }
        .card-img-container {
            position: relative;
            overflow: hidden;
            border-radius: 8px;
        }

        .card-img-container img {
            transition: transform 0.3s ease;
            width: 100%;
            height: auto;
        }

        .card-img-container:hover img {
            transform: scale(1.05); /* Scale up the image on hover */
        }

        .badge-link {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        
    </style>
             <div class="content" style="position:;">
                <div class="row">
                    <center>
                        <h4><?php echo e(config('app.name')); ?> welcome you back!</h4>
                        <p>To empower your financial investment here</p>
                    </center>
                </div>
                
                <div id="investments" class="row">
                    <div class="col text-white" >
                        <h4 class="fw-bold ml-5 pl-8">Total Balance</h4>
                        <p class="ml-5 pl-8">Keep track of your finances</p>
                        <div class="row w-bold ml-5 pl-8">
                            <br><br><br>
                            <div class="col-12 mt-4">
                                <div class="row mt-16 align-items-center">
                                    <div class="col-6 position-relative">
                                        <h3 class="" id="balance"> <!-- Removed onclick attribute -->
                                            KES. <?php echo e(Auth::user()->balance); ?>

                                        </h3>
                                        <!-- Glass shading element -->
                                        <div id="glassShading" class="glass-shading position-absolute top-0 start-0"></div>
                                    </div>
                                    <div class="col-6">
                                            <i id="eyeIcon" onclick="toggleBlur()"  class="bi bi-eye" style="color: #fff; font-size: 20px;"></i>
                                    </div>
                                </div>
                            </div>
        
                        </div>
                    </div>
                </div>
                
                <!-- Additional overlay_1 -->
                <div class="row overlay_1 mb-3">
                    <div class="col-8 offset-2 p-2 bg-success text-white rounded-pill text-center">
                        <div class="row justify-content-between p-2">
                            <div onclick="go('deposit')" class="col-4 text-center">
                                <i class="bi bi-arrow-up-circle" style="font-size: 20px;"></i>
                                <div>Topup</div>
                            </div>
                            <div onclick="go('withdraw')" class="col-4 text-center">
                                <i class="bi bi-cash-coin"style="font-size: 20px;"></i>
                                <!--<img src="<?php echo e(env('APP_RES')); ?>/icons/receive.png" style="width: 30px;">-->
                                <div>Withdraw</div>
                            </div>
                            <div onclick="go('vip')" class="col-4 text-center">
                                <i class="bi bi-box-arrow-in-up-right" style="font-size: 20px;"></i>
                                <div>Invest</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-12">
                            <div class="py-3 text-center">
                                <h4 class="m-0">My Assets</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="card p-3">
                                <div class="card-img-container">
                                    <img src="<?php echo e(env('APP_RES')); ?>/assets/images/schwab1.png" class="card-img-top rounded" alt="Package Logo" style="max-height: 200px;">
                                    <a href="vip" class="badge badge-primary badge-link">
                                        <i class="bi bi-view-list" style="font-size: 20px;"></i>
                                    </a>
                                </div>
                                <h4 class="fw-bold fs-5"><?php echo e(config('app.name')); ?> ASSETS</h4>
                                <p class="text-muted mb-3"><?php echo e(Auth::user()->username); ?>, <?php echo e(Auth::user()->id); ?></p>
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-8">
                                        <p class="fw-normal mb-0">Your Investment</p>
                                    </div>
                                    <div class="col-4 text-end">
                                        <p class="fw-bold mb-0">KES.<?php echo e(Auth::user()->investments); ?></p>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-8">
                                        <p class="fw-normal mb-0">Daily Yield</p>
                                    </div>
                                    <div class="col-4 text-end">
                                        <p class="fw-bold mb-0">KES.<?php echo e(number_format(Auth::user()->investments * 0.12, 2)); ?></p>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-8">
                                        <p class="fw-normal mb-0">Total Returns (30 days)</p>
                                    </div>
                                    <div class="col-4 text-end">
                                        <p class="fw-bold mb-0">KES.<?php echo e(number_format(Auth::user()->investments * 0.12 * 30, 2)); ?></p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <button onclick="go('deposit')" class="w-100 btn btn-success btn-sm btn-block">TOPUP</button>
                                    </div>
                                    <div class="col-6">
                                        <button onclick="go('withdraw')" class="w-100 btn btn-outline-dark btn-sm btn-block">WITHDRAW</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              
                <div class="container">
                    <div class="row my-3">
                        <div class="col-8">
                            <h4 class="ms-3">Transaction</h4>
                        </div>
                        <div class="col-4 text-end ">
                            <a href="transactions" class="text-muted text-decoration-none fs-6 mr-3">View All</a>
                        </div>
                    </div>
                </div>
                <?php
                    $transactions = \DB::table('deposits')
                        ->select(
                            'deposits.created_at as date',
                            'deposits.amount',
                            'deposits.status',
                            \DB::raw("'deposit' as type"),
                        )
                        ->where('deposits.username', '=', Auth::user()->username)
                        ->union(
                            \DB::table('cashouts')
                                ->select(
                                    'cashouts.created_at as date',
                                    'cashouts.amount',
                                    'cashouts.status',
                                    \DB::raw("'cashout' as type"),
                                )
                                ->where('cashouts.username', '=', Auth::user()->username),
                        )
                        ->latest('date') // Order by the 'date' column in descending order
                        ->limit(4) // Limit to the latest 4 records
                        ->get();
                ?>
                <?php if($transactions->count() > 0): ?>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row m-2 p-2" style="border-radius: 8px; <?php if($trx->type == 'cashout'): ?> background-color: #C8E6C9; <?php elseif($trx->type == 'deposit'): ?> background-color: #FFCDD2; <?php endif; ?>">
                            <div class="col-7">
                                <div class="row">
                                    <div class="col">
                                        <p class="h6 fw-bold">
                                            <?php echo e(config('app.name')); ?> - KES
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <p class="h6 fw-bold text-muted"><?php echo e($trx->date); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-5">
                                <div class="row">
                                    <div class="col text-end">
                                        <p class="h6 fw-bold <?php if($trx->type == 'cashout'): ?>text-success <?php elseif($trx->type == 'deposit'): ?>text-danger <?php endif; ?>"><?php echo e($trx->type); ?> sale</p>
                                    </div>
                                    <div class="col text-end">
                                        <p class="h6 fw-bold">KES.<?php echo e($trx->amount); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <center>
                    <div class="row bg-gray-400 m-2 p-2" style="background-color:#C2C4D1;border-radius:8px;">
                        <p>No Transactions yet</p>
                    </div>
                </center>
                <?php endif; ?>
        
        
            </div>
        
<script>
                 function toggleBlur() {
                    var balance = document.getElementById("balance");
                    var glassShading = document.getElementById("glassShading");
                    var eyeIcon = document.getElementById("eyeIcon");
            
                    // Toggle blur class and glass shading visibility
                    balance.classList.toggle("blurry");
                    glassShading.classList.toggle("d-none");
            
                    // Toggle eye icon class
                    eyeIcon.classList.toggle("bi-eye-slash");
                    eyeIcon.classList.toggle("bi-eye");
                }
            </script>
<?php $__env->stopSection(); ?>
      
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xexdzgmh/schwab.cashgrowdailyinvestment.com.ng/resources/views/user/dashboard.blade.php ENDPATH**/ ?>