<?php $__env->startSection('content'); ?>
<center><b>All Deposits</b></center>
<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table me-1"></i>
        Deposit Management
    </div>
    <div class="card-body">
        <div style="overflow-x: auto;">
            <table id="datatablesSimple" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>Method</th>
                        <th>Image</th>
                        <th>Email</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Transaction</th>
                        <th>Time</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    
                                     
                   <?php $__currentLoopData = DB::table('deposits')->where('status', 'Unpaid')->paginate(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
 
                    <tr id="deposit-row-<?php echo e($deposit->id); ?>">
                        <td><?php echo e($deposit->id); ?></td>
                        <td><?php echo e($deposit->phone); ?></td>
                        <td><?php echo e($deposit->method); ?></td>
                        <td>
                            <?php if($deposit->images): ?>
                         <a href="javascript:void(0)" onclick="viewImage('<?php echo e(asset('public/deposit_screenshots/' . $deposit->images)); ?>')">
                                <img src="<?php echo e(asset('public/deposit_screenshots/' . $deposit->images)); ?>" 
                                     alt="Deposit Image" 
                                     style="width: 50px; height: 50px; cursor: pointer;">
                            </a>


                            <?php else: ?>
                            N/A
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($deposit->email); ?></td>
                        <td><?php echo e($deposit->amount); ?></td>
                        <td id="status-<?php echo e($deposit->id); ?>"><?php echo e($deposit->status); ?></td>
                        <td><?php echo e($deposit->transaction); ?></td>
                        <td><?php echo e($deposit->created_at); ?></td>
                        <td>
                            <button onclick="approveDeposit(<?php echo e($deposit->id); ?>)" class="btn btn-success" id="approve-btn-<?php echo e($deposit->id); ?>">Approve</button>
                            <button onclick="rejectDeposit(<?php echo e($deposit->id); ?>)" class="btn btn-danger" id="reject-btn-<?php echo e($deposit->id); ?>">Reject</button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination Links -->
        <div class="mt-3">
            <?php echo e(DB::table('deposits')->paginate(10)->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imageModalLabel">View Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" alt="Deposit Image" style="max-width: 100%; height: auto;">
            </div>
        </div>
    </div>
</div>

<script>
    // View Image in Modal
    function viewImage(imageUrl) {
        const modalImage = document.getElementById('modalImage');
        modalImage.src = imageUrl;
        const imageModal = new bootstrap.Modal(document.getElementById('imageModal'));
        imageModal.show();
    }

    // Approve Deposit
    function approveDeposit(depositId) {
        if (confirm('Are you sure you want to approve this deposit?')) {
            fetch('<?php echo e(route("deposit.approve")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'approved';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }

    // Reject Deposit
    function rejectDeposit(depositId) {
        if (confirm('Are you sure you want to reject this deposit?')) {
            fetch('<?php echo e(route("deposit.reject")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({ deposit_id: depositId })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById(`status-${depositId}`).innerText = 'rejected';
                    alert(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    }
</script>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/starlightassets.site/resources/views/user/allPendingDeposits.blade.php ENDPATH**/ ?>