<?php $__env->startSection('content'); ?>

<?php
    $packages = DB::table('packages')->get();
    $interns = DB::table('invest')->where('user_id', Auth::user()->id)->where('capital', 200)->get()->count();
    $hideIntern = false;

    if($interns >= 2){
        $hideIntern = "true";
    }


$dailywealth = DB::table('wealthcreation')->where('user_id', Auth::user()->id)->sum('returns') * $settings->rate;
$daily_income = DB::table('invest')->where('user_id', Auth::user()->id)->sum('returns') * $settings->rate;
$trades = DB::table('invest')->where('user_id', Auth::user()->id)->sum('capital') * $settings->rate;
$cashouts = DB::table('cashouts')->where('username', Auth::user()->username)->sum('amount') * $settings->rate;

?>

<?php


 
            
             $user = Auth::user();
            $countryCode = $user->country ?? '';

            if ($countryCode == 'Kenya') { // Kenya
                $conversionRate = 130; // 1 USDT = 130 KES
                $currency = 'KES';
            } elseif ($countryCode == 'Zambia') { // Zambia
                $conversionRate = 25; // 1 USDT = 30 ZMW
                $currency = 'ZMW';
            } elseif ($countryCode == 'Tanzania') { // Zambia
                $conversionRate = 2575; // 1 USDT = 30 ZMW
                $currency = 'TZS';
            } elseif ($countryCode == 'Ghana') { // Gana
                $conversionRate = 11; // 1 USDT = 15 GHS
                $currency = 'GHS';
                
            }  elseif ($countryCode == 'Uganda') { // Ghana
                $conversionRate = 3560; // 1 USDT = 30 ZMW
                $currency = 'UGX';
            }  elseif ($countryCode == 'South Sudan') { // Ghana
                $conversionRate = 4512; // 1 USDT = 30 ZMW
                $currency = 'SSP';
            } else { // Default to USD for other countries
                $conversionRate = 1;
                $currency = 'USD';
            }

            $convertedBalance = $user->balance / $conversionRate;
            $min = 1 * $conversionRate;



?>
<!-- Summary Box -->

<!-- Page Title -->
<img src ="public/assets/img/WhatsApp Image 2025-05-27 at 23.50.59.jpeg" style="width:330px;height:150px;">
<div class="text-center my-4">
    <h2 class="fw-bold">🎯 Choose Job Level</h2>
</div>

<!-- Package Display -->
<div class="container">
    <div class="row g-4">
        <?php if(Session::has('success')): ?>
            <div class="alert alert-success text-sm text-center" role="alert">
                ✅ <?php echo e(Session::get('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
            <div class="alert alert-danger text-sm text-center" role="alert">
                ❌ <?php echo e(Session::get('error')); ?>

            </div>
        <?php endif; ?>

        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($pkg->price == 200 && $hideIntern == "true"): ?>
                <div class="col-md-4">
                    <div class="card shadow-sm">
                        <center>
                            <b>🎓 You have finished intern level</b><br>
                            <small>🚀 Upgrade to next Task level</small>
                        </center>
                    </div>
                </div>
            <?php else: ?>
                <div class="col-md-4">
                    <div class="card shadow-lg border-0">
                        <div class="card-header position-relative bg-primary text-white text-center fw-bold">
                            📅 <?php echo e($pkg->days); ?> days
                            <?php if($pkg->vip): ?>
                                <span class="position-absolute top-0 end-0 bg-warning text-light fw-bold px-3 py-1 rounded-pill m-1">
                                    🎖️ <?php echo e($pkg->vip); ?>

                                </span>
                            <?php endif; ?>
                        </div>
                        <div class="card-body text-start">
                            <h3 class="text-primary fw-bold">💵 <?php echo e($currency); ?>.<?php echo e(number_format($pkg->price  * $conversionRate, 2)); ?></h3>
                            <p class="text-muted mb-2">📈 Daily Income: 💰 <?php echo e($currency); ?>.<?php echo e(number_format($pkg->daily_income * 0.01 * $pkg->price * $conversionRate, 2)); ?></p>
                            <p class="fw-bold">📋 Tasks per day: <?php echo e($pkg->daily_tasks); ?></p>
                            <p>Total Salary: <span class="fw-bold text-primary">💼 <?php echo e($currency); ?>.<?php echo e(number_format($pkg->returns  * $conversionRate, 2)); ?></span></p>
                            <div class="d-flex justify-content-between align-items-center mt-4">
                                <button
                                    class="btn btn-info w-100"
                                    style="background-color:#FF0033;"
                                    data-bs-toggle="modal"
                                    data-bs-target="#investmentModal"
                                    data-package-id="<?php echo e($pkg->id); ?>"
                                    data-min-amount="<?php echo e($pkg->price * $settings->rate); ?>"
                                    data-daily-income="<?php echo e($pkg->daily_income * $settings->rate); ?>"
                                    data-days="<?php echo e($pkg->days); ?>"
                                >
                                    🚀 Subscribe Now
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<!-- Investment Modal -->
<div class="modal fade" id="investmentModal" tabindex="-1" aria-labelledby="investmentModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form method="GET" action="<?php echo e(url('package')); ?>">
            <input type="hidden" name="p" id="modal_package_id">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-dark" id="investmentModalLabel">💼 Enter Investment Amount</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="amount" class="form-label text-dark">💲 Amount (<?php echo e($currency); ?>) </label><h3 class="text-primary fw-bold">💵 </h3>
                        <input type="number" class="form-control text-dark" name="amount" id="modal_amount" placeholder="Type amount e.g. 20000" min="1" required>
                    </div>
                    <div id="calcDisplay" class="text-dark" style="display: none;">
                        <p>📈 <strong>Daily Income:</strong> <span id="dailyIncome" class="text-success fw-bold"></span></p>
                        <p>📆 <strong>Total Return (60 days):</strong> <span id="totalReturn" class="text-primary fw-bold"></span></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-info w-100" style="background-color:#FF0033;">✅ Submit Now</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    var investmentModal = document.getElementById('investmentModal');

    investmentModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var packageId = button.getAttribute('data-package-id');

        var inputPackageId = investmentModal.querySelector('#modal_package_id');
        inputPackageId.value = packageId;
    });

    const amountInput = document.getElementById('modal_amount');
    const dailyIncomeElem = document.getElementById('dailyIncome');
    const totalReturnElem = document.getElementById('totalReturn');
    const calcDisplay = document.getElementById('calcDisplay');

    amountInput.addEventListener('input', function () {
        let amount = parseFloat(this.value);

        if (isNaN(amount) || amount < 1) {
            calcDisplay.style.display = 'none';
            return;
        }

        let percent = 0;

        if (amount >= 5000) {
            percent = 5;
        } else if (amount >= 1000) {
            percent = 4.5;
        } else if (amount >= 500) {
            percent = 4;
        } else if (amount >= 100) {
            percent = 3.5;
        } else if (amount >= 50) {
            percent = 3;
        } else if (amount >= 20) {
            percent = 2.5;
        } else {
            percent = 0;
        }

        if (percent === 0) {
            calcDisplay.style.display = 'none';
        } else {
            const dailyIncome = (amount * (percent / 100)).toFixed(2);
            const totalReturn = (dailyIncome * 60).toFixed(2);

            dailyIncomeElem.textContent = "<?php echo e($settings->currency); ?> " + dailyIncome;
            totalReturnElem.textContent = "<?php echo e($settings->currency); ?> " + totalReturn;
            calcDisplay.style.display = 'block';
        }
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/p-h.site/resources/views/investment.blade.php ENDPATH**/ ?>