<?php $__env->startSection('content'); ?>
<style>
       .profile-section {
        background: url('/assets/bg.jpg') no-repeat center center;
        background-size: cover;
        padding: 2rem;
        color: white;
        text-align: center;
        position: relative;
    }

    .profile-img {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: #ccc url('public/assets/img/user-removebg-preview.png') center/cover no-repeat;
        margin: 0 auto;
    }
</style>
<main class="container mt-5">
    <div class="profile-img"></div>
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Change Password</h5>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('user.profile.resetPassword')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <div class="mb-3">
                    <label for="new_password" class="form-label">New Password</label>
                    <div class="input-group">
                        <input type="password" name="new_password" id="new_password" class="form-control" required>
                        <button type="button" class="btn btn-outline-secondary" onclick="toggleField('new_password')">Show</button>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="new_password_confirmation" class="form-label">Confirm Password</label>
                    <div class="input-group">
                        <input type="password" name="new_password_confirmation" id="new_password_confirmation" class="form-control" required>
                        <button type="button" class="btn btn-outline-secondary" onclick="toggleField('new_password_confirmation')">Show</button>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary w-100">Update Password</button>
            </form>

            <?php if(session('new_password')): ?>
                <div class="alert alert-info mt-4 d-flex align-items-center justify-content-between">
                    <div>
                        <strong>Your New Password:</strong>
                        <span id="shownPw"><?php echo e(session('new_password')); ?></span>
                    </div>
                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="togglePw()">Hide</button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

<script>
    function toggleField(id) {
        const input = document.getElementById(id);
        input.type = input.type === "password" ? "text" : "password";
    }

    function togglePw() {
        const span = document.getElementById('shownPw');
        const current = span.innerText;
        if (current === '********') {
            span.innerText = '<?php echo e(session('new_password')); ?>';
        } else {
            span.innerText = '********';
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/p-h.site/resources/views/settings/resetpassword.blade.php ENDPATH**/ ?>