<?php $__env->startSection('content'); ?>

<?php
use Carbon\Carbon;

$levels = DB::table('invest')->where('user_id', Auth::user()->id)->where('status', 1)->get();
?>

<style>
.locked-card {
  position: relative; /* Ensures the icon is positioned relative to the card */
  overflow: hidden; /* Prevents the icon from spilling outside the card */
  text-align: center; /* Optional: Align card content */
}

.lock-icon {
  position: absolute;
  top: 50%; /* Center vertically */
  left: 50%; /* Center horizontally */
  transform: translate(-50%, -50%); /* Adjust position to center */
  font-size: 3rem; /* Adjust the icon size */
  color: rgba(0, 0, 0, 0.5); /* Semi-transparent color */
  z-index: 2; /* Ensures the icon is above the card content */
  font-weight:bold;
}

.locked-card .card-body {
  opacity: 0.5; /* Dim the card content to emphasize the lock */
}

.fade-card{
  opacity: 0.5; /* Dim the card content to emphasize the lock */
}

}

</style>
<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true" style="font-family: Arial, sans-serif; width:96%; margin-left:2%;">

  <div class="modal-dialog" style="margin: 30px auto;">
    <div class="modal-content" style="border-radius: 15px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); overflow: hidden; background-color: #dadcad;">

      <div class="modal-header px-3 py-1" style="background-color: #007bff; color: white;">
        <h5 class="modal-title text-white" id="staticBackdropLabel" style="font-size: 1.25rem;">Review Product</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="color: white; font-size: 1rem;"></button>
      </div>

      <div class="modal-body" style="padding: 20px;">
        <p id="productName" style="font-size: 1.1rem; font-weight: bold; color: #333;"></p>
        <p id="productDescription" style="font-size: 1rem; color: #555; margin-bottom: 15px;display:none;"></p>
        <img id="productImage" src="" alt="Product Image" class="img-fluid" style="max-height: 300px; object-fit: cover; width: 100px; border-radius: 8px;">

  <!-- Rating Buttons: Good, Better, Best -->
        <div style="display: flex; justify-content: space-around; margin-top: 20px;">
          <button id="goodRating" class="btn btn-success btn-sm " style="width: 30%;">Good</button>
          <button id="betterRating" class="btn btn-warning btn-sm" style="width: 30%;">Better</button>
          <button id="bestRating" class="btn btn-primary btn-sm" style="width: 30%;">Best</button>
        </div>

        <!-- Star Rating -->
        <div style="display: flex; justify-content: center; margin-top: 15px;">
          <span id="star1" class="star" style="font-size: 2rem; cursor: pointer;">☆</span>
          <span id="star2" class="star" style="font-size: 2rem; cursor: pointer;">☆</span>
          <span id="star3" class="star" style="font-size: 2rem; cursor: pointer;">☆</span>
          <span id="star4" class="star" style="font-size: 2rem; cursor: pointer;">☆</span>
          <span id="star5" class="star" style="font-size: 2rem; cursor: pointer;">☆</span>
        </div>

      
      </div>

      <div class="modal-footer px-3 py-1" style="background-color: #f1f1f1; padding: 15px; text-align: right;">
        <button type="button" class="btn btn-secondary btn-sm float-start" data-bs-dismiss="modal" style="background-color: #6c757d; border: none; padding: 10px 20px; border-radius: 5px;">Close</button>
        <a type="button" id="productLink" href="task-done?id=id" class="btn btn-primary btn-sm" style="background-color: #28a745; border: none; padding: 10px 20px; border-radius: 5px; font-weight: bold;">Submit</a>
      </div>

    </div>
  </div>
</div>



<div class="py-3">
    <div class="container mt-4">
        <div class="section-heading d-flex align-items-center justify-content-between rtl-flex-d-row-r">
            <h6>Review Products</h6>
            <!-- Layout Options-->
            <div class="layout-options"><a class="active" href="#"><i class="ti ti-list-check"></i></a></div>
        </div>
        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        
       <?php if(\Session::has('success')): ?>
            <div class="alert alert-success">
                <ul>
                    <li><?php echo \Session::get('success'); ?></li>
                </ul>
            </div>
        <?php endif; ?>


        <div class="row g-2">
            <?php if($levels->count() > 0): ?>
                <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
             
                
                $ratings = rand(2, 5); 
                
                $product = DB::table('products')
                                ->inRandomOrder() // Pulls random rows // Limits to the user's daily tasks
                                ->first();
                $job = DB::table('packages')->where('price', $level->capital)->first();
                
                //check if its ready
                    //get profit foreach user
                   $profit=$level->returns;
                   //get trading period
                   $period = $level->period;
                   //get days paid so far
                   $paid = $level->days_paid;
                   $to = Carbon::now()->addHours(3);
                   //real end date
                   $from = Carbon::parse($level->date)->addHours(3);

                   $diff_in_days = $to->diffInDays($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
                 //  dd("$diff_in_hrs");

                   $timeOnly = Carbon::parse($level->date)->addHours(3)->format('H:i:s');

                
                ?>
                
            
                    <div class="col-12 ">
                        <?php if($days_not_paid > 0): ?>
                        <div class="card  horizontal-product-card" data-bs-toggle="modal" data-bs-target="#staticBackdrop" onclick="setModalContent('<?php echo e($product->name); ?>', '<?php echo e($product->description); ?>', '<?php echo e($product->image_url); ?>', '<?php echo e($level->id); ?>')">
                            <div class="d-flex align-items-center">
                                <div class="product-thumbnail-side">
                                    <!-- Thumbnail -->
                                    <span class="product-thumbnail d-block" >
                                        <img src="<?php echo e($product->image_url); ?>" alt="<?php echo e($product->name); ?>">
                                    </span>
                                    <!-- Delete -->
                                    <span class="delete-btn" ></span>
                                </div>
                                <div class="product-description">
                                    <!-- Product Title -->
                                    <span class="product-title d-block" >
                                        <?php echo e($product->name); ?>

                                    </span>
                                    <!-- Price -->
                                    <p class="sale-price">
                                        <i class="ti ti-currency-dollar"></i><?php echo e($product->price); ?><span><?php echo e(number_format($product->price * 0.97, 2)); ?></span>
                                    </p>
                                    <!-- Rating -->
                                   <div class="product-rating d-flex p-2 justify-content-between align-items-center">
                                        <i class="ti ti-star-filled"><?php echo e($ratings); ?></i> 
                                      
                                        <!-- Button trigger modal -->
                                        <button type="button"  class="btn btn-primary btn-sm mr-2" data-bs-toggle="modal" data-bs-target="#staticBackdrop" onclick="setModalContent('<?php echo e($product->name); ?>', '<?php echo e($product->description); ?>', '<?php echo e($product->image_url); ?>', '<?php echo e($level->id); ?>')">
                                            Review
                                        </button>
                                    </div>


                                </div>
                            </div>
                        </div>
                       <?php else: ?>
                       <div class="card  horizontal-product-card py-2 px-2">
                           <center>
                               <p>This Level Task is not yet Ready</p>
                                 Check It past <?php echo e($timeOnly); ?>

                           </center>
                       </div>
                        
                       <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Select All Products-->
                <div class="col-12">
                    <div class="select-all-products-btn mt-2">
                        <a <?php if($levels->count() > 0): ?> disabled <?php endif; ?> class="btn btn-primary btn-lg w-100 <?php if($levels->count() > 0): ?> disabled <?php endif; ?>" href="home?payme=true"><i class="ti ti-circle-plus me-1 h6"></i> Collect today's payments</a>
                    </div>
                </div>
            <?php else: ?>
            
               <?php
               $product = DB::table('products')
                        ->inRandomOrder() // Pulls random rows
                        ->first();
                $ratings = rand(2, 5);
               ?>
            
                  <div class="col-12  locked-card">
                        <div class="card fade-card horizontal-product-card" data-bs-toggle="modal" data-bs-target="#staticBackdrop" onclick="setModalContent('<?php echo e($product->name); ?>', '<?php echo e($product->description); ?>', '<?php echo e($product->image_url); ?>', 0)">
                            <div class="d-flex align-items-center">
                                <div class="product-thumbnail-side">
                                    <!-- Thumbnail -->
                                    <span class="product-thumbnail d-block" >
                                        <img src="<?php echo e($product->image_url); ?>" alt="<?php echo e($product->name); ?>">
                                    </span>
                                    <!-- Delete -->
                                    <span class="delete-btn" ><i class="ti ti-check"></i></span>
                                </div>
                                <div class="product-description">
                                    <!-- Product Title -->
                                    <span class="product-title d-block" >
                                        Sample product
                                    </span>
                                    <!-- Price -->
                                    <p class="sale-price">
                                        <i class="ti ti-currency-dollar"></i><?php echo e($product->price); ?><span><?php echo e(number_format($product->price * 0.97, 2)); ?></span>
                                    </p>
                                    <!-- Rating -->
                                   <div class="product-rating d-flex p-2 justify-content-between align-items-center">
                                        <i class="ti ti-star-filled"><?php echo e($ratings); ?></i> 
                                      
                                        <!-- Button trigger modal -->
                                        <button type="button" id="productLink" class="btn btn-primary btn-sm mr-2" data-bs-toggle="modal" data-bs-target="#staticBackdrop" onclick="setModalContent('<?php echo e($product->name); ?>', '<?php echo e($product->description); ?>', '<?php echo e($product->image_url); ?>')">
                                            Review
                                        </button>
                                    </div>


                                </div>
                            </div>
                        </div>
                          <div class="lock-icon">
                            <i class="ti ti-lock" style="font-size:60px;"></i> <!-- Themify lock icon -->
                          </div>
                    </div>

                  <div class="col-12">
                    <div class="select-all-products-btn mt-2">
                        <a  class="btn btn-primary btn-lg w-100 " href="vip"><i class="ti ti-list me-1 h6"></i> Subscribe Job To Start Tasks</a>
                    </div>
                 </div>
               
            <?php endif; ?>
        </div>
    </div>
</div>
<!-- Inline JS to handle user interaction -->
<script>
  // Handle rating buttons click
  let selectedRating = null;

  function resetRatingButtons() {
    // Remove highlights from all buttons
    document.getElementById('goodRating').classList.remove('btn-outline-dark');
    document.getElementById('betterRating').classList.remove('btn-outline-dark');
    document.getElementById('bestRating').classList.remove('btn-outline-dark');

    // Remove background color from all buttons
    document.getElementById('goodRating').style.backgroundColor = '';
    document.getElementById('betterRating').style.backgroundColor = '';
    document.getElementById('bestRating').style.backgroundColor = '';
  }

  document.getElementById('goodRating').onclick = function() {
    selectedRating = 'Good';
    resetRatingButtons();
    this.style.backgroundColor = '#02d0fd'; // Highlight selected button
    this.classList.add('border border-dark');
    updateRatingDisplay();
  };
  document.getElementById('betterRating').onclick = function() {
    selectedRating = 'Better';
    resetRatingButtons();
    this.style.backgroundColor = '#02d0fd'; // Highlight selected button
    this.classList.add('border border-dark');
    updateRatingDisplay();
  };
  document.getElementById('bestRating').onclick = function() {
    selectedRating = 'Best';
    resetRatingButtons();
    this.style.backgroundColor = '#02d0fd'; // Highlight selected button
    this.classList.add('border');
    updateRatingDisplay();
  };

  // Handle star rating
  let selectedStars = 0;
  const stars = document.querySelectorAll('.star');
  stars.forEach(function(star, index) {
    star.onclick = function() {
      selectedStars = index + 1;
      updateStarDisplay();
    };
  });

  // Function to update the star display
  function updateStarDisplay() {
    stars.forEach(function(star, index) {
      star.innerText = index < selectedStars ? '★' : '☆';
      star.style.color = index < selectedStars ? 'yellow' : '';
    });
  }

  // Toggle comment section visibility
  document.getElementById('toggleComment').onclick = function() {
    const commentSection = document.getElementById('commentSection');
    if (commentSection.style.display === 'none') {
      commentSection.style.display = 'block';
      document.getElementById('toggleComment').innerText = 'Remove Comment';
    } else {
      commentSection.style.display = 'none';
      document.getElementById('toggleComment').innerText = 'Leave a Comment';
    }
  };

  // Function to update the rating display
  function updateRatingDisplay() {
    //alert('You have selected: ' + selectedRating);
  }
</script>


<script>
    // Function to set the modal content dynamically
    function setModalContent(name, description, image, id) {
        
        // Set product details dynamically
        document.getElementById('productName').textContent = "Review Product: " + name;
        document.getElementById('productDescription').textContent = description;
        document.getElementById('productImage').src = image;
        //set link dynamically
        // Set the link dynamically
        const linkElement = document.getElementById('productLink');
        linkElement.href = `task-done?id=${id}`; // Dynamically add the id to the link

    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/cdp24.site/resources/views/todo.blade.php ENDPATH**/ ?>