<?php $__env->startSection('content'); ?>
<?php

            
             $user = Auth::user();
            $countryCode = $user->country ?? '';

            if ($countryCode == 'Kenya') { // Kenya
                $conversionRate = 130; // 1 USDT = 130 KES
                $currency = 'KES';
            } elseif ($countryCode == 'Zambia') { // Zambia
                $conversionRate = 25; // 1 USDT = 30 ZMW
                $currency = 'ZMW';
            } elseif ($countryCode == 'Tanzania') { // Zambia
                $conversionRate = 2575; // 1 USDT = 30 ZMW
                $currency = 'TZS';
            } elseif ($countryCode == 'Ghana') { // Gana
                $conversionRate = 11; // 1 USDT = 15 GHS
                $currency = 'GHS';
                
            }  elseif ($countryCode == 'Uganda') { // Ghana
                $conversionRate = 3560; // 1 USDT = 30 ZMW
                $currency = 'UGX';
            }  elseif ($countryCode == 'South Sudan') { // Ghana
                $conversionRate = 4512; // 1 USDT = 30 ZMW
                $currency = 'SSP';
            } else { // Default to USD for other countries
                $conversionRate = 1;
                $currency = 'USD';
            }

            $convertedBalance = $user->balance / $conversionRate;
            $min = 1 * $conversionRate;






           $cashouts = DB::table('cashouts')->where('username', Auth::user()->username)->get();

            

?>

<main class="container mt-3">
    <h6 class="mb-3">Withdrawal History</h6>

    <?php if($cashouts->isEmpty()): ?>
        <div class="alert alert-info small">No withdrawal records found.</div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered table-sm table-hover" style="font-size: 0.52rem;">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                     
                        <th>Amount</th>
                        <th>Phone</th>
                        <th style="font-size:8px;">Receiving Account</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $cashouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            
                            <td><?php echo e($currency); ?>.<?php echo e(number_format($c->amount * $conversionRate, 2)); ?></td>
                            <td><?php echo e($c->phone); ?></td>
                            <td style="font-size:8px;"><?php echo e($c->wallet_address); ?></td>
                            <td>
                                <?php if($c->status == 'pending'): ?>
                                    <span class="badge bg-warning text-dark">Pending</span>
                                <?php elseif($c->status == 'approved'): ?>
                                    <span class="badge bg-success">Approved</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Rejected</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d M Y, h:i A')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</main>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bfundeoz/p-h.site/resources/views/cashouts/cashHistory.blade.php ENDPATH**/ ?>