<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <link href="<?php echo e(env('APP_RES')); ?>/bootstrap/css/bootstrap.css" rel="stylesheet">
    <link href="<?php echo e(env('APP_RES')); ?>/assets/css/style.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
</head>

<body>
    <?php
        $r = request()->path();
    ?>
    <div id="app">
        <nav class="navbar navbar-expand-md bg-light">
            <div class="container">

                <div class="dropdown">
                    <button class="btn p-0 m-0" type="button" class="btn btn-primary dropdown-toggle"
                        data-bs-toggle="dropdown" aria-expanded="false" data-bs-auto-close="outside">
                        <img src="<?php echo e(env('APP_RES')); ?>/icons/bars.png" style="width: 30px;">
                    </button>
                    <div class="dropdown-menu p-1 " style="width:320px; height:500px;background-color:#f2f2f2;">
                        <li class="mb-1">
                            <a class="dropdown-item bg-gray-200" href="home"
                                <?php if($r == 'home'): ?> aria-current="true" <?php endif; ?> href="home">Home</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="deposit"
                                <?php if($r == 'deposit'): ?> aria-current="true" <?php endif; ?>>Deposit Funds</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="transactions"
                                <?php if($r == 'transactions'): ?> aria-current="true" <?php endif; ?>>Transactions</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="vip"
                                <?php if($r == 'vip'): ?> aria-current="true" <?php endif; ?>>Our Products</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="withdraw"
                                <?php if($r == 'withdraw'): ?> aria-current="true" <?php endif; ?>>Withdrawal</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="downlines"
                                <?php if($r == 'downlines'): ?> aria-current="true" <?php endif; ?>>My Teams</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="profile"
                                <?php if($r == 'profile'): ?> aria-current="true" <?php endif; ?>>Profile</a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout"
                                <?php if($r == 'logout'): ?> aria-current="true" <?php endif; ?>>Logout</a>
                        </li>
                    </div>
                </div>

            </div>
        </nav>


        <main class="py-4 content">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
    <script>
        function go(url) {
            window.location.replace(url);
        }
    </script>
    <script>
        // Set session values to JavaScript variables
        var current_link_value = sessionStorage.getItem('activeMenuItem');
        // Get the element with the ID "menu-item"
        var menuItem = document.getElementById(current_link_value);

        // Check if the element exists
        if (menuItem !== null) {
            // Add the class "active" to the element
            menuItem.classList.add("active");
        } else {
            console.log("Element with ID 'menu-item' not found");
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
        integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous">
    </script>
    <script src="<?php echo e(env('APP_RES')); ?>/bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo e(env('APP_RES')); ?>/assets/js/main.js"></script>
</body>

</html>
<?php /**PATH /home/uniquesq/schwab.cch-hub.top/resources/views/layouts/main.blade.php ENDPATH**/ ?>